// ============================================================================
//  $Id: TCamacCoincidenceRegisterModule.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TCamacCoincidenceRegisterModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TCamacCoincidenceRegisterModule::TCamacCoincidenceRegisterModule( TCamacCrateController* cc7x00, Tint slot, Tint nch, Tdata_t datalen )
  : TCamacModule( cc7x00, slot, nch, datalen )
{;}

TCamacCoincidenceRegisterModule::TCamacCoincidenceRegisterModule( const TCamacCoincidenceRegisterModule& right )
  : TCamacModule( right )
{;}

TCamacCoincidenceRegisterModule::~TCamacCoincidenceRegisterModule()
{;}

const TCamacCoincidenceRegisterModule& TCamacCoincidenceRegisterModule::operator=( const TCamacCoincidenceRegisterModule& right )
{
  *( (TCamacModule*)this ) = *( (TCamacModule*)(&right) );
  return( *this );
}

Tbool TCamacCoincidenceRegisterModule::operator==( const TCamacCoincidenceRegisterModule& right ) const
{
  return( *( (TCamacModule*)this ) == *( (TCamacModule*)(&right) ) );
}

Tbool TCamacCoincidenceRegisterModule::operator!=( const TCamacCoincidenceRegisterModule& right ) const
{
  return( *( (TCamacModule*)this ) != *( (TCamacModule*)(&right) ) );
}

Tvoid TCamacCoincidenceRegisterModule::FillData( TDataElement& element, Tint channel )
{
  Tstring head = "TCamacCoincidenceRegisterModule::FillData: ";
  if ( channel < 0 || channel >= theNumberOfChannels ) {
    Tcerr << head << "invalid ID " << channel << Tendl;
    element.FillData( &theStatus, tTypeInt, 1 );
  } else {
    Read();
    element.FillData( &theCamacData, tTypeUnsignedInt, 1 );
  }
  return;
}
