// ============================================================================
//  $Id: TCamacScalerModule.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TCamacScalerModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TCamacScalerModule::TCamacScalerModule( TCamacCrateController* cc7x00, Tint slot, Tint nch, Tdata_t datalen )
  : TCamacModule( cc7x00, slot, nch, datalen )
{;}

TCamacScalerModule::TCamacScalerModule( const TCamacScalerModule& right )
  : TCamacModule( right )
{;}

TCamacScalerModule::~TCamacScalerModule()
{;}

const TCamacScalerModule& TCamacScalerModule::operator=( const TCamacScalerModule& right )
{
  *( (TCamacModule*)this ) = *( (TCamacModule*)(&right) );
  return( *this );
}

Tbool TCamacScalerModule::operator==( const TCamacScalerModule& right ) const
{
  return( *( (TCamacModule*)this ) == *( (TCamacModule*)(&right) ) );
}

Tbool TCamacScalerModule::operator!=( const TCamacScalerModule& right ) const
{
  return( *( (TCamacModule*)this ) != *( (TCamacModule*)(&right) ) );
}

Tvoid TCamacScalerModule::FillData( TDataElement& element, Tint channel )
{
  if ( channel < 0 || channel >= theNumberOfChannels ) {
    Tcerr << "TCamacScalerModule::FillData: invalid ID " << channel << Tendl;
    element.FillData( &theStatus, tTypeInt, 1 );
  } else {
    Read( channel );
    element.FillData( &theCamacData, tTypeUnsignedInt, 1 );
  }
  return;
}

Tint TCamacScalerModule::ReadOverflowChannel()
{
  return( execute( 0, 1 ) );
}

Tint TCamacScalerModule::ClearOverflowChannel()
{
  return( execute( 0, 10 ) );
}

Tint TCamacScalerModule::IncrementAllChannel()
{
  return( execute( 0, 25 ) );
}

Tint TCamacScalerModule::Clear()
{
  ClearOverflowChannel();
  return( execute( 0, tCamacClear ) );
}

Tint TCamacScalerModule::Update()
{
  return( Clear() );
}

Tint TCamacScalerModule::Initialize()
{
  return( Clear() );  
}
