// ============================================================================
//  $Id: TCrate.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TCrate.hh"
#include "TModule.hh"

TCrate::TCrate()
  : theModuleList( 0 ), theModuleSpecifiedTable(),
    theCrateCapacity( 1 ), theNumberOfModules( 0 ), 
    theCrateIndex( 0 )
{
  theModuleSpecifiedTable.clear();
  allocate( theCrateCapacity );
}

TCrate::~TCrate()
{
  free();
}

Tint TCrate::InstallModule( TModule* module, const Tstring& id, const TstringList& groups )
{
  if ( FindModule( id ) != 0 ) {
    Tcerr << "TCrate::InstallModule: already exist Module identified as " << id << "." << Tendl;
      return( theNumberOfModules );
  }

  if ( theNumberOfModules >= theCrateCapacity )
    ResizeCrate( theCrateCapacity *= 2 );
  theModuleList[ theNumberOfModules ] = module;
  theNumberOfModules ++;
  theCrateIndex = theNumberOfModules - 1;

  TModuleSpecified spec( theCrateIndex - 1, id, groups );
  theModuleSpecifiedTable.push_back( spec );

  return( theNumberOfModules );
}

Tint TCrate::InstallModule( TModule* module, const Tstring& id, const Tstring& group )
{
  TstringList groups;
  groups.push_back( group );
  return( InstallModule( module, id, groups ) );
}

Tint TCrate::RemoveModule( Tint index )
{
  Tstring head = "TCrate::RemoveModule: ";
  if ( index < 0 || index >= theNumberOfModules ) {
    Tcerr << head << "invalid index " << index << "." << Tendl;
    return( theNumberOfModules );
  }
  theCrateIndex = index;
  Tstring id = theModuleSpecifiedTable[ theCrateIndex ].GetModuleID();
  delete theModuleList[ theCrateIndex ];
  Tcout << head << id << " module was removed." << Tendl;
  for ( Tint i = theCrateIndex; i < theNumberOfModules; i ++ )
    theModuleList[ i ] = theModuleList[ i + 1 ];
  theNumberOfModules --;
  theModuleSpecifiedTable.erase( theModuleSpecifiedTable.begin() + theCrateIndex );
  return( theNumberOfModules );
}

Tint TCrate::RemoveModule( const Tstring& id )
{
  for ( Tsize_t i = 0; i < theModuleSpecifiedTable.size(); i ++ ) {
    if ( theModuleSpecifiedTable[ i ].GetModuleID() == id ) {
      Tint index = theModuleSpecifiedTable[ i ].GetModuleIndex();
      return( RemoveModule( index ) );
    }
  }
  return( theNumberOfModules );
}

Tint TCrate::RemoveModule( const TstringList& groups )
{
  for ( Tsize_t i = 0; i < theModuleSpecifiedTable.size(); i ++ ) {
    if ( theModuleSpecifiedTable[ i ].IsSameGroup( groups ) ) {
      Tint index = theModuleSpecifiedTable[ i ].GetModuleIndex();
      RemoveModule( index );
    }
  }
  return( theNumberOfModules );
}

Tvoid TCrate::ClearCrate()
{
  Tstring head = "TCrate::ClearCrate: ";
  for ( Tint i = 0; i < theNumberOfModules; i ++ ) {
    if ( theModuleList[ i ] ) {
      Tstring id = theModuleSpecifiedTable[ i ].GetModuleID();
      delete theModuleList[ i ];
      Tcout << head << id << " module was removed." << Tendl;;
    }
  }

  theModuleSpecifiedTable.clear();

  theNumberOfModules = 0;
  theCrateIndex = 0;
  return;
}

Tbool TCrate::ResizeCrate( Tint capacity )
{
  if ( theNumberOfModules >= capacity ) {
    Tcerr << "TCrate::ResizeCrate: invalid capacity" << Tendl;
    return( Tfalse );
  }
  theCrateCapacity = capacity;
  TModule** newModules = new TModule* [ theCrateCapacity ];
  for ( Tint i = 0; i < theNumberOfModules; i ++ )
    newModules[ i ] = theModuleList[ i ];
  delete [] theModuleList;
  theModuleList = newModules;
  theCrateIndex = theNumberOfModules - 1;
  return( Ttrue );
}

TModule* TCrate::NextModule()
{
  if ( theCrateIndex < 0 || theCrateIndex >= theNumberOfModules )
    return( 0 );
  return( theModuleList[ theCrateIndex ++ ] );
}

TModule* TCrate::FindModule( const Tstring& id )
{
  for ( Tsize_t index = 0; index < theModuleSpecifiedTable.size(); index ++ ) {
    if ( theModuleSpecifiedTable[ index ].GetModuleID() == id ) {
      return( GetModule( index ) );
    }
  }
  return( 0 );
}

TModule* TCrate::GetModule( Tint index )
{
  if ( index < 0 || index >= theNumberOfModules ) {
    Tcerr << "TCrate::GetModule: invalid index" << Tendl;
    return( 0 );
  }
  theCrateIndex = index;
  return( theModuleList[ theCrateIndex ] );
}

TModule* TCrate::GetModule( const Tstring& id )
{
  return( FindModule( id ) );
}

TModule* TCrate::GetModule()
{
  return( GetModule( theCrateIndex ) );
}

Tvoid TCrate::Clear( const TstringList& groups )
{
  for ( Tint i = 0; i < theNumberOfModules; i ++ ) {
    if ( theModuleSpecifiedTable[ i ].IsSameGroup( groups ) ) {
      theModuleList[ i ] -> Clear();
    }
  }
  return;
}

Tvoid TCrate::Clear( const Tstring& group )
{
  TstringList groups;
  groups.push_back( group );
  Clear( groups );
  return;
}

Tvoid TCrate::Update( const TstringList& groups )
{
  for ( Tint i = 0; i < theNumberOfModules; i ++ ) {
    if ( theModuleSpecifiedTable[ i ].IsSameGroup( groups ) ) {
      theModuleList[ i ] -> Update();
    }
  }
  return;
}

Tvoid TCrate::Update( const Tstring& group )
{
  TstringList groups;
  groups.push_back( group );
  Update( groups );
  return;
}

Tvoid TCrate::Initialize( const TstringList& groups )
{
  for ( Tint i = 0; i < theNumberOfModules; i ++ ) {
    if ( theModuleSpecifiedTable[ i ].IsSameGroup( groups ) ) {
      theModuleList[ i ] -> Initialize();
    }
  }
  return;
}

Tvoid TCrate::Initialize( const Tstring& group )
{
  TstringList groups;
  groups.push_back( group );
  Initialize( groups );
  return;
}

Tvoid TCrate::ClearAllModules()
{
  for ( Tint i = 0; i < theNumberOfModules; i ++ ) {
    if ( theModuleList[ i ] ) {
      theModuleList[ i ] -> Clear();
    }
  }
  return;
}

Tvoid TCrate::UpdateAllModules()
{
  for ( Tint i = 0; i < theNumberOfModules; i ++ ) {
    if ( theModuleList[ i ] ) {
      theModuleList[ i ] -> Update();
    }
  }
  return;
}

Tvoid TCrate::InitializeAllModules()
{
  for ( Tint i = 0; i < theNumberOfModules; i ++ ) {
    if ( theModuleList[ i ] ) {
      theModuleList[ i ] -> Initialize();
    }
  }
  return;
}

Tvoid TCrate::ClearModule( const Tstring& id )
{
  TModule* module = FindModule( id );
  if ( module ) {
    module -> Clear();
  }
  return;
}

Tvoid TCrate::UpdateModule( const Tstring& id )
{
  TModule* module = FindModule( id );
  if ( module ) {
    module -> Update();
  }
  return;
}

Tvoid TCrate::InitializeModule( const Tstring& id )
{
  TModule* module = FindModule( id );
  if ( module ) {
    module -> Initialize();
  }
  return;
}

Tvoid TCrate::free()
{
  static const Tstring head = "TCrate::free: ";
  for ( Tint i = 0; i < theNumberOfModules; i ++ ) {
    if ( theModuleList[ i ] ) {
      Tstring id = theModuleSpecifiedTable[ i ].GetModuleID();
      delete theModuleList[ i ];
      Tcout << head << id << " module was removed." << Tendl;
    }
  }
  delete [] theModuleList;

  theModuleSpecifiedTable.clear();

  theCrateCapacity = 0;
  theNumberOfModules = 0;
  theCrateIndex = 0;
  return;
}

Tvoid TCrate::allocate( Tint capacity )
{
  theCrateCapacity = capacity;
  theModuleList = new TModule* [ theCrateCapacity ];
  return;
}
