// ============================================================================
//  $Id: TSoftwareClockModule.hh,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TSOFTWARECLOCKMODULE_HH
#define __TSOFTWARECLOCKMODULE_HH

#include "Tglobals.h"
#include "TSoftwareModule.hh"

class TDataSegment;
class TDataElement;

class TSoftwareClockModule
  : public TSoftwareModule
{
  public:
    enum { 
      tCompleteTime, 
      tCompleteTimeFormat, 
      tLocalYear,
      tLocalMonth,
      tLocalDate,
      tLocalDay,
      tLocalHour,
      tLocalMinute,
      tLocalSecond,
      tLocalTimeZone,
      tNumberOfChannels
    };

  private:
    Tstring theCompleteTime;
    static Tstring theCompleteTimeFormat;
    Tstring theLocalYear;
    Tstring theLocalMonth;
    Tstring theLocalDate;
    Tstring theLocalDay;
    Tstring theLocalHour;
    Tstring theLocalMinute;
    Tstring theLocalSecond;
    Tstring theLocalTimeZone;

  public:
    TSoftwareClockModule( Tint nchannel = tNumberOfChannels );
    TSoftwareClockModule( const TSoftwareClockModule& right );
    ~TSoftwareClockModule();

  public:
    const TSoftwareClockModule& operator=( const TSoftwareClockModule& right );
    Tbool operator==( const TSoftwareClockModule& right ) const;
    Tbool operator!=( const TSoftwareClockModule& right ) const;

  public:
    Tint Clear();
    Tint Update();
    Tint Initialize();
    Tvoid FillData( TDataElement& element, Tint channel );

  public:
    const Tstring& GetCompleteTime() const;
    const Tstring& GetLocalYear() const;
    const Tstring& GetLocalMonth() const;
    const Tstring& GetLocalDate() const;
    const Tstring& GetLocalDay() const;
    const Tstring& GetLocalHour() const;
    const Tstring& GetLocalMinute() const;
    const Tstring& GetLocalSecond() const;
    const Tstring& GetLocalTimeZone() const;
    Tvoid SetCompleteTime( const Tstring& time );
    Tvoid SetLocalYear( const Tstring& year );
    Tvoid SetLocalMonth( const Tstring& month );
    Tvoid SetLocalDate( const Tstring& date );
    Tvoid SetLocalDay( const Tstring& day );
    Tvoid SetLocalHour( const Tstring& hour );
    Tvoid SetLocalMinute( const Tstring& minute );
    Tvoid SetLocalSecond( const Tstring& second );
    Tvoid SetLocalTimeZone( const Tstring& zone );

  public:
    static const Tstring& GetCompleteTimeFormat();
    static Tvoid SetCompleteTimeFormat( const Tstring& format );

  private:
    Tvoid setCurrentTime();
    const Tstring& getStringData( Tint channel ) const;

};

inline const Tstring& TSoftwareClockModule::GetCompleteTimeFormat()
{
  return( TSoftwareClockModule::theCompleteTimeFormat );
}

inline Tvoid TSoftwareClockModule::SetCompleteTimeFormat( const Tstring& format )
{
  TSoftwareClockModule::theCompleteTimeFormat = format;
  return;
}

inline const Tstring& TSoftwareClockModule::GetCompleteTime() const
{
  return( theCompleteTime );
}

inline const Tstring& TSoftwareClockModule::GetLocalYear() const
{
  return( theLocalYear );
}

inline const Tstring& TSoftwareClockModule::GetLocalMonth() const
{
  return( theLocalMonth );
}

inline const Tstring& TSoftwareClockModule::GetLocalDate() const
{
  return( theLocalDate );
}

inline const Tstring& TSoftwareClockModule::GetLocalDay() const
{
  return( theLocalDay );
}

inline const Tstring& TSoftwareClockModule::GetLocalHour() const
{
  return( theLocalHour );
}

inline const Tstring& TSoftwareClockModule::GetLocalMinute() const
{
  return( theLocalMinute );
}

inline const Tstring& TSoftwareClockModule::GetLocalSecond() const
{
  return( theLocalSecond );
}

inline const Tstring& TSoftwareClockModule::GetLocalTimeZone() const
{
  return( theLocalTimeZone );
}

inline Tvoid TSoftwareClockModule::SetCompleteTime( const Tstring& time )
{
  theCompleteTime = time;
  return;
}

inline Tvoid TSoftwareClockModule::SetLocalYear( const Tstring& year )
{
  theLocalYear = year;
  return;
}

inline Tvoid TSoftwareClockModule::SetLocalMonth( const Tstring& month )
{
  theLocalMonth = month;
  return;
}

inline Tvoid TSoftwareClockModule::SetLocalDate( const Tstring& date )
{
  theLocalDate = date;
  return;
}

inline Tvoid TSoftwareClockModule::SetLocalDay( const Tstring& day )
{
  theLocalDay = day;
  return;
}

inline Tvoid TSoftwareClockModule::SetLocalHour( const Tstring& hour )
{
  theLocalHour = hour;
  return;
}

inline Tvoid TSoftwareClockModule::SetLocalMinute( const Tstring& minute )
{
  theLocalMinute = minute;
  return;
}

inline Tvoid TSoftwareClockModule::SetLocalSecond( const Tstring& second )
{
  theLocalSecond = second;
  return;
}

inline Tvoid TSoftwareClockModule::SetLocalTimeZone( const Tstring& zone )
{
  theLocalTimeZone = zone;
  return;
}

#endif
