// ============================================================================
//  $Id: TSoftwareRunInformationModule.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TSoftwareRunInformationModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TSoftwareRunInformationModule::TSoftwareRunInformationModule()
  : TSoftwareModule( 0 ), theRunInformationTable()
{
  theRunInformationTable.Clear();
  theNumberOfChannels = theRunInformationTable.GetNumberOfRows();
}

TSoftwareRunInformationModule::TSoftwareRunInformationModule( const TRunInformationTable& table )
  : TSoftwareModule( 0 ), theRunInformationTable( table )
{
  theNumberOfChannels = theRunInformationTable.GetNumberOfRows();
}

TSoftwareRunInformationModule::TSoftwareRunInformationModule( const TSoftwareRunInformationModule& right )
  : TSoftwareModule( right ), theRunInformationTable( right.theRunInformationTable )
{
  theNumberOfChannels = theRunInformationTable.GetNumberOfRows();
}

TSoftwareRunInformationModule::~TSoftwareRunInformationModule()
{;}

Tvoid TSoftwareRunInformationModule::FillData( TDataElement& element, Tint channel )
{
  if ( channel < 0 || channel >= theNumberOfChannels ) {
    Tcerr << "TSoftwareRunInformationModule::FillData: invalid ID " << channel << Tendl;
    theStatus = -EFAULT;
    element.FillData( &theStatus, tTypeInt, 1 );
  } else {
    Tstring item = theRunInformationTable.GetItem( channel );
    Tstring value = theRunInformationTable.GetValue( channel );
    element.FillData( &value, tTypeString, 1 );
    element.SetID( item );
  }
  return;
}

const TSoftwareRunInformationModule& TSoftwareRunInformationModule::operator=( const TSoftwareRunInformationModule& right )
{
  *( (TSoftwareModule*)this ) = *( (TSoftwareModule*)(&right) );
  theRunInformationTable = right.theRunInformationTable;
  return( *this );
}

Tbool TSoftwareRunInformationModule::operator==( const TSoftwareRunInformationModule& right ) const
{
  Tbool retval = Ttrue;
  retval &= ( *( (TSoftwareModule*)this ) == *( (TSoftwareModule*)(&right) ) );
  retval &= ( theRunInformationTable == right.theRunInformationTable );
  return( retval );
}

Tbool TSoftwareRunInformationModule::operator!=( const TSoftwareRunInformationModule& right ) const
{
  Tbool retval = Tfalse;
  retval |= ( *( (TSoftwareModule*)this ) != *( (TSoftwareModule*)(&right) ) );
  retval |= ( theRunInformationTable != right.theRunInformationTable );
  return( retval );
}

Tint TSoftwareRunInformationModule::Clear()
{
  TstringList valuelist = theRunInformationTable.GetValueList();
  for ( Tsize_t i = 0; i < valuelist.size(); i ++ )
    valuelist[ i ] = "";
  theRunInformationTable.SetValueList( valuelist );
  theNumberOfChannels = theRunInformationTable.GetNumberOfRows();
  return( theStatus = tStatusSuccess );
}

Tint TSoftwareRunInformationModule::Update()
{
  return( theStatus = tStatusSuccess );
}

Tint TSoftwareRunInformationModule::Initialize()
{
  theRunInformationTable.Clear();
  theNumberOfChannels = theRunInformationTable.GetNumberOfRows();
  return( theStatus = tStatusSuccess );  
}
