// ============================================================================
//  $Id: TVmeRpv130Module.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TVmeRpv130Module.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TVmeRpv130Module::TVmeRpv130Module( Toff_t offset, Tint mapsize, Tint nch )
  : TVmeModule( nch, offset, mapsize, tA16D16 ),
    theReadoutMode( tReadoutWithThrough )
{;}

TVmeRpv130Module::TVmeRpv130Module( const TVmeRpv130Module& right )
  : TVmeModule( right ), 
    theReadoutMode( right.theReadoutMode )
{;}

TVmeRpv130Module::~TVmeRpv130Module()
{;}

const TVmeRpv130Module& TVmeRpv130Module::operator=( const TVmeRpv130Module& right )
{
  *( (TVmeModule*)this ) = *( (TVmeModule*)(&right) );
  theReadoutMode = right.theReadoutMode;
  return( *this );
}

Tbool TVmeRpv130Module::operator==( const TVmeRpv130Module& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TVmeModule*)this ) == *( (TVmeModule*)(&right) ) );
  ret &= ( theReadoutMode == right.theReadoutMode );
  return( ret );
}

Tbool TVmeRpv130Module::operator!=( const TVmeRpv130Module& right ) const
{
  Tbool ret = Tfalse;
  ret |= ( *( (TVmeModule*)this ) != *( (TVmeModule*)(&right) ) );
  ret |= ( theReadoutMode != right.theReadoutMode );
  return( ret );
}

Tint TVmeRpv130Module::Clear()
{
  setBit( (TUshort*)( theBaseAddress + CSR1 ), 0, 1 );
  setBit( (TUshort*)( theBaseAddress + CSR1 ), 1, 1 );

  setBit( (TUshort*)( theBaseAddress + CSR2 ), 0, 1 );
  setBit( (TUshort*)( theBaseAddress + CSR2 ), 1, 1 );
  return( theStatus = tStatusSuccess );
}

Tint TVmeRpv130Module::Update()
{
  return( Clear() );
}

Tint TVmeRpv130Module::Initialize()
{
  Clear();
  Disable();
  return( theStatus = tStatusSuccess );
}

Tvoid TVmeRpv130Module::FillData( TDataElement& element, Tint channel )
{
  if ( channel < 0 || channel >= theNumberOfChannels ) {
    Tcerr << "TVmeRpv130Module::FillData: invalid ID " << channel << Tendl;
    theStatus = -EFAULT;
    element.FillData( &theStatus, tTypeInt, 1 );
  } else {
    TUshort data = Read();
    element.FillData( &data, tTypeUnsignedShort, 1 );
  }
  return;
}

Tvoid TVmeRpv130Module::Pulse( Tint pattern )
{
  *( (TUshort*)( theBaseAddress + PULSE ) ) = (TUshort)pattern;
  return;
}

Tvoid TVmeRpv130Module::Level( Tint pattern )
{
  *( (TUshort*)( theBaseAddress + LEVEL ) ) = (TUshort)pattern;
  return;
}

Tvoid TVmeRpv130Module::Enable()
{
  setBit( (TUshort*)( theBaseAddress + CSR1 ), 4, 1 );
  setBit( (TUshort*)( theBaseAddress + CSR1 ), 6, 1 );

  setBit( (TUshort*)( theBaseAddress + CSR2 ), 4, 1 );
  setBit( (TUshort*)( theBaseAddress + CSR2 ), 6, 1 );
  return;
}

Tvoid TVmeRpv130Module::Disable()
{
  setBit( (TUshort*)( theBaseAddress + CSR1 ), 4, 0 );
  setBit( (TUshort*)( theBaseAddress + CSR1 ), 6, 0 );

  setBit( (TUshort*)( theBaseAddress + CSR2 ), 4, 0 );
  setBit( (TUshort*)( theBaseAddress + CSR2 ), 6, 0 );
  return;
}

TUshort TVmeRpv130Module::Read()
{
  TUshort data;
  switch ( theReadoutMode ) {
    case tReadoutWithLatch1:
      data = *( (TUshort*)( theBaseAddress + LATCH1 ) );
    case tReadoutWithLatch2:
      data = *( (TUshort*)( theBaseAddress + LATCH2 ) );
    case tReadoutWithRSFF:
      data = *( (TUshort*)( theBaseAddress + RSFF ) );
    case tReadoutWithThrough:
      data = *( (TUshort*)( theBaseAddress + THROUGH ) );
    default:
      data = *( (TUshort*)( theBaseAddress + RSFF ) );
  }
  data &= 0x00ff;
  return( data );
}
