// ============================================================================
//  $Id: TInputObjectStream.hh,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TINPUTOBJECTSTREAM_HH
#define __TINPUTOBJECTSTREAM_HH

#include "Tglobals.h"
#include "TObjectStream.hh"

class TStreamableObject;
class TObjectFilter;

class TInputObjectStream
  : public TObjectStream
{

  public:
    TInputObjectStream( Tstream_t streamtype = tUnknownStream );
    TInputObjectStream( TObjectFilter* filter, Tstream_t streamtype = tUnknownStream );

  protected:
    virtual ~TInputObjectStream();

  public:
    virtual Tint ReadData( TStreamableObject& object ) = 0;
    friend Tint operator>>( TInputObjectStream& left, TStreamableObject& object );
    friend Tint operator>>( TInputObjectStream& left, const TStreamableObject& object );

};

inline Tint operator>>( TInputObjectStream& left, TStreamableObject& object )
{
  return( left.ReadData( object ) );
}

inline Tint operator>>( TInputObjectStream& left, const TStreamableObject& object )
{
  return( left.ReadData( *(TStreamableObject*)(&object) ) );
}

#endif
