// ============================================================================
//  $Id: TOutputObjectStream.hh,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TOUTPUTOBJECTSTREAM_HH
#define __TOUTPUTOBJECTSTREAM_HH

#include "Tglobals.h"
#include "TObjectStream.hh"

class TStreamableObject;
class TObjectFilter;

class TOutputObjectStream
  : public TObjectStream
{

  public:
    TOutputObjectStream( Tstream_t streamtype = tUnknownStream );
    TOutputObjectStream( TObjectFilter* filter, Tstream_t streamtype = tUnknownStream );

  protected:
    virtual ~TOutputObjectStream();

  public:
    virtual Tint WriteData( TStreamableObject& object ) = 0;
    friend Tint operator<<( TOutputObjectStream& left, TStreamableObject& object );
    friend Tint operator<<( TOutputObjectStream& left, const TStreamableObject& object );

};

inline Tint operator<<( TOutputObjectStream& left, TStreamableObject& object )
{
  return( left.WriteData( object ) );
}

inline Tint operator<<( TOutputObjectStream& left, const TStreamableObject& object )
{
  return( left.WriteData( *(TStreamableObject*)(&object) ) );
}

#endif
