// ============================================================================
//  $Id: TReadoutElement.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TReadoutElement.hh"
#include "TDataElement.hh"
#include "TModule.hh"

TReadoutElement::TReadoutElement( TModule* module, const Tstring& id )
  : TReadoutIdentification( id ), theModule( module )
{;}

TReadoutElement::TReadoutElement( const TReadoutElement& right )
  : TReadoutIdentification( right ), theModule( right.theModule )
{;}

TReadoutElement::~TReadoutElement()
{;}

TDataElement TReadoutElement::ReadData( Tint channel )
{
  TDataElement element( tTypeUnknown, theID );
  theModule -> FillData( element, channel );
  return( element );
}

const TReadoutElement& TReadoutElement::operator=( const TReadoutElement& right )
{
  *( (TReadoutIdentification*)this ) = *( (TReadoutIdentification*)(&right) );
  theModule = right.theModule;
  return( *this );
}

Tbool TReadoutElement::operator==( const TReadoutElement& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TReadoutIdentification*)this ) == *( (TReadoutIdentification*)(&right) ) );
  ret &= ( *theModule == *(right.theModule) );
  return( ret );
}

Tbool TReadoutElement::operator!=( const TReadoutElement& right ) const
{
  Tbool ret = Tfalse;
  ret |= ( *( (TReadoutIdentification*)this ) != *( (TReadoutIdentification*)(&right) ) );
  ret |= ( *theModule != *(right.theModule) );
  return( ret );
}
