// ============================================================================
//  $Id: TSystemTimer.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TSystemTimer.hh"

static const Tdouble _nclock = (Tdouble)( sysconf( _SC_CLK_TCK ) );

TSystemTimer::TSystemTimer()
  : theValidTimes( Tfalse ), theBeginOfRealTime( -1 ), theEndOfRealTime( -1 )
{;}

TSystemTimer::TSystemTimer( const TSystemTimer& right )
  : theValidTimes( right.theValidTimes ),
    theBeginOfRealTime( right.theBeginOfRealTime ),
    theEndOfRealTime( right.theEndOfRealTime )
{;}

TSystemTimer::~TSystemTimer()
{;}

const TSystemTimer& TSystemTimer::operator=( const TSystemTimer& right )
{
  theValidTimes = right.theValidTimes;
  theBeginOfRealTime = right.theBeginOfRealTime;
  theEndOfRealTime = right.theEndOfRealTime;
  return( *this );
}

Tostream& operator<<( Tostream& tos, const TSystemTimer& right )
{
  if ( right.IsValid() ) {
    tos << "Real=" << right.GetRealElapsedTime() << "s ";
    tos << "User(parent/child)=" << right.GetUserElapsedTime() << "s/";
    tos << right.GetUserElapsedTimeOfChildren() << "s ";
    tos << "Sys(parent/child)=" << right.GetSystemElapsedTime() << "s/";
    tos << right.GetSystemElapsedTimeOfChildren() << "s";
  } else {
    tos << "Real=***s User(parent/child)=***s/***s Sys(parent/child)=***s/***s";
  }
  return( tos );
}

Tdouble TSystemTimer::GetRealElapsedTime() const
{
  if ( theValidTimes == Tfalse ) {
    Tstring head = "TSystemTimer::GetRealElapsedTime: ";
    Tcerr << head << "timer not stopped or times not recorded" << Tendl;
  }
  return( ( theEndOfRealTime - theBeginOfRealTime ) / _nclock );
}

Tdouble TSystemTimer::GetSystemElapsedTime() const
{
  if ( theValidTimes == Tfalse ) {
    Tstring head = "TSystemTimer::GetSystemElapsedTime: ";
    Tcerr << head << "timer not stopped or times not recorded" << Tendl;
  }
  return( ( theEndOfTimes.tms_stime - theBeginOfTimes.tms_stime ) / _nclock );
}

Tdouble TSystemTimer::GetSystemElapsedTimeOfChildren() const
{
  if ( theValidTimes == Tfalse ) {
    Tstring head = "TSystemTimer::GetSystemElapsedTimeOfChildren: ";
    Tcerr << head << "timer not stopped or times not recorded" << Tendl;
  }
  return( ( theEndOfTimes.tms_cstime - theBeginOfTimes.tms_cstime ) / _nclock );
}

Tdouble TSystemTimer::GetUserElapsedTime() const
{
  if ( theValidTimes == Tfalse ) {
    Tstring head = "TSystemTimer::GetUserElapsedTime: ";
    Tcerr << head << "timer not stopped or times not recorded" << Tendl;
  }
  return( ( theEndOfTimes.tms_utime - theBeginOfTimes.tms_utime ) / _nclock );
}

Tdouble TSystemTimer::GetUserElapsedTimeOfChildren() const
{
  if ( theValidTimes == Tfalse ) {
    Tstring head = "TSystemTimer::GetUserElapsedTimeOfChildren: ";
    Tcerr << head << "timer not stopped or times not recorded" << Tendl;
  }
  return( ( theEndOfTimes.tms_cutime - theBeginOfTimes.tms_cutime ) / _nclock );
}

Tvoid TSystemTimer::Start()
{
  theValidTimes = Tfalse;
  theBeginOfRealTime = times( &theBeginOfTimes );
  return;
}

Tvoid TSystemTimer::Pause()
{
  // under construction.
  return;
}

Tvoid TSystemTimer::Restart()
{
  // under construction.
  return;
}

Tvoid TSystemTimer::Reset()
{
  theValidTimes = Tfalse;
  theBeginOfRealTime = -1;
  theEndOfRealTime = -1;
  return;
}

Tvoid TSystemTimer::Continue()
{
  if ( (Tint)theBeginOfRealTime == -1 ) {
    Tcerr << "TSystemTimer::Continue(): timer not started.";
    return;
  }
  theValidTimes = Tfalse;
  return;
}

Tvoid TSystemTimer::Stop()
{
  theEndOfRealTime = times( &theEndOfTimes );
  theValidTimes = Ttrue;
  return;
}
