// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TDataDeflation.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 3 ) {
    Tcerr << "usage: " << argv[ 0 ] << " <input> <output>" << Tendl;
    return( -1 );
  }
  const Tstring ifname = argv[ 1 ];
  const Tstring ofname = argv[ 2 ];

  TDataDeflation deflation;

  const Tsize_t bufsize = 256;
  Tvoid* input = new Tbyte[ bufsize ]; 

  Tifstream ifs;
  ifs.open( ifname.c_str() );

  Tofstream ofs;
  ofs.open( ofname.c_str() );

  while ( ifs.good() && !ifs.eof() ) {
    ifs.read( input, bufsize );
    if ( ifs.gcount() < bufsize ) {
      deflation.Compress( input, ifs.gcount(), Ttrue );
    } else {
      deflation.Compress( input, ifs.gcount() );
    }
    ofs.write( deflation.GetDeflatedData(), deflation.GetSizeOfDeflatedData() );
  }

  ifs.close();
  ofs.close();

  return( 0 );
}
