// ============================================================================
//  $Id: ifilter.cc,v 1.1 2003/01/06 11:32:59 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TDataRecord.hh"
#include "TInputObjectFile.hh"
#include "TCompressObjectFilter.hh"
#include "TBenchmark.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<filename>" << Tendl;
    return( -1 );
  }
  const Tstring filename = argv[ 1 ];
  TCompressObjectFilter filter;
  TInputObjectFile ifile( &filter, filename );
  Tint nevents = 0;
  Tint datasize = 0;

  TDataRecord record;
  TBenchmark bench;
  bench.Start();
  while ( ( ifile >> record ) != 0 ) {
    Tcout << record << Tendl;
    datasize += record.GetDataSize();
    nevents ++;
  }
  bench.Stop();
  Tcout << bench << Tendl;

  Tcout << nevents << " events, ";
  Tcout << datasize << Tslash << ifile.GetTotalDataSize();
  Tcout << " byte data has been read from " << filename << "." << Tendl;

  return( 0 );
}
