// ============================================================================
//  $Id: ofilter.cc,v 1.1 2003/01/06 11:32:59 iwai Exp $
//  $Name:  $
// ============================================================================
#include "Tglobals.h"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TOutputObjectFile.hh"
#include "TCompressObjectFilter.hh"
#include "TBenchmark.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<nevent>" << Tendl;
    return( -1 );
  }
  const Tint nevent = atoi( argv[ 1 ] );
  const Tstring filename = "output.drec";
  TCompressObjectFilter filter;
  TOutputObjectFile ofile( &filter, filename );
  Tint datasize = 0;
  Tint nevents = 0;

  TBenchmark bench;
  bench.Start();
  for ( Tint i = 0; i < nevent; i ++ ) {
    TDataRecord record = testrecord( i );
    ofile << record;
    datasize += record.GetDataSize();
    nevents ++;
  }
  bench.Stop();
  Tcout << bench << Tendl;

  Tcout << nevents << " events, ";
  Tcout << datasize << Tslash << ofile.GetTotalDataSize();
  Tcout << " byte data has been written down " << filename << "." << Tendl;

  return( 0 );
}
