// ============================================================================
//  $Id: BtRunSummary.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "BtRunSummary.hh"

BtRunSummary::BtRunSummary()
  : theRunID( 0 ), 
    theRecordName(), 
    theRecordSize( 0 ), 
    theNumberOfCsIEvents( 0 ), 
    theNumberOfScalerEvents( 0 ),
    theNumberOfAllEvents( 0 ),
    theRunInformationTable(),
    theAccumulatedScaler( 8, 0 ),
    theRunBeginTime(),
    theRunEndTime()
{;}

BtRunSummary::~BtRunSummary()
{;}

Tvoid BtRunSummary::Initialize()
{
  theRunID = 0;
  theRecordName.erase();
  theRecordSize = 0;
  theNumberOfCsIEvents = 0; 
  theNumberOfScalerEvents = 0;
  theNumberOfAllEvents = 0;
  theRunInformationTable.Clear();
  for ( Tsize_t i = 0; i < theAccumulatedScaler.size(); i ++ )
    theAccumulatedScaler[ i ] = 0;
  theRunBeginTime.erase();
  theRunEndTime.erase();
  return;
}

TRunInformationTable BtRunSummary::GenerateRunSummaryTable() const
{
  TstringList itemlist;
  TstringList valuelist;

  // BEGIN OF ITEM DEFINITION
  itemlist.push_back( "Run ID" );
  itemlist.push_back( "Identification of object file" );
  itemlist.push_back( "Size of object file" );
  itemlist.push_back( "Run Start" );
  itemlist.push_back( "Run Stop" );
  itemlist.push_back( "Number of CsI events" );
  itemlist.push_back( "Number of Scaler events" );
  itemlist.push_back( "Number of <font color=#ff0000>All</font> events" );
  for ( Tsize_t i = 0; i < theRunInformationTable.GetItemList().size(); i ++ )
    itemlist.push_back( "Run information (" + ( theRunInformationTable.GetItemList() )[ i ] + ")" );
  itemlist.push_back( "Accumulated scaler counts (PIN1)" );
  itemlist.push_back( "Accumulated scaler counts (PIN2)" );
  itemlist.push_back( "Accumulated scaler counts (PIN3)" );
  itemlist.push_back( "Accumulated scaler counts (PIN4)" );
  itemlist.push_back( "Accumulated scaler counts (PIN5)" );
  itemlist.push_back( "Accumulated scaler counts (TRG1)" );
  itemlist.push_back( "Accumulated scaler counts (TRG2)" );
  itemlist.push_back( "Accumulated scaler counts (****)" );
  // END OF ITEM DEFINITION


  // BEGIN OF VALUE DEFINITION
  valuelist.push_back( itostr( theRunID ) );
  valuelist.push_back( theRecordName );
  valuelist.push_back( itostr( theRecordSize ) );
  valuelist.push_back( theRunBeginTime );
  valuelist.push_back( theRunEndTime );
  valuelist.push_back( itostr( theNumberOfCsIEvents ) );
  valuelist.push_back( itostr( theNumberOfScalerEvents ) );
  valuelist.push_back( itostr( theNumberOfAllEvents ) );
  for ( Tsize_t i = 0; i < theRunInformationTable.GetValueList().size(); i ++ )
    valuelist.push_back( ( theRunInformationTable.GetValueList() )[ i ] );
  for ( Tsize_t i = 0; i < theAccumulatedScaler.size(); i ++ )
  valuelist.push_back( itostr( theAccumulatedScaler[ i ] ) );
  // BEGIN OF VALUE DEFINITION


  TRunInformationTable table( itemlist, valuelist );
  return( table );
}
