// ============================================================================
//  $Id: BtRunSummary.hh,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __BTRUNSUMMARY_HH
#define __BTRUNSUMMARY_HH

#include "TRunInformationTable.hh"
#include "TChannel.hh"

class BtRunSummary
{

  private:
    Tint theRunID;
    Tstring theRecordName;
    Tint theRecordSize;
    Tint theNumberOfCsIEvents;
    Tint theNumberOfScalerEvents;
    Tint theNumberOfAllEvents;
    TRunInformationTable theRunInformationTable;
    TChannel theAccumulatedScaler;
    Tstring theRunBeginTime;
    Tstring theRunEndTime;

  public:
    BtRunSummary();
    ~BtRunSummary();

  public:
    TRunInformationTable GenerateRunSummaryTable() const;
    Tvoid Initialize();

  public:
    Tint GetRunID() const;
    const Tstring& GetRecordName() const;
    Tint GetRecordSize() const;
    Tint GetNumberOfCsIEvents() const;
    Tint GetNumberOfScalerEvents() const;
    Tint GetNumberOfAllEvents() const;
    const TRunInformationTable& GetRunInformationTable() const;
    Tvoid AddAccumulatedScaler( Tint ch, Tint ncounts );
    Tvoid SetAccumulatedScaler( const TChannel& sclaer );
    const TChannel& GetAccumulatedScaler() const;
    const Tstring& GetRunBeginTime() const;
    const Tstring& GetRunEndTime() const;
    Tvoid SetRunID( Tint runid );
    Tvoid SetRecordName( const Tstring& recname );
    Tvoid SetRecordSize( Tint size );
    Tvoid SetNumberOfCsIEvents( Tint nevents );
    Tvoid SetNumberOfScalerEvents( Tint nevents );
    Tvoid SetNumberOfAllEvents( Tint nevents );
    Tvoid SetRunInformationTable( const TRunInformationTable& table );
    Tvoid SetRunBeginTime( const Tstring& time );
    Tvoid SetRunEndTime( const Tstring& time );

};

inline Tint BtRunSummary::GetRunID() const
{
  return( theRunID );
}

inline const Tstring& BtRunSummary::GetRecordName() const
{
  return( theRecordName );
}

inline Tint BtRunSummary::GetRecordSize() const
{
  return( theRecordSize );
}

inline Tint BtRunSummary::GetNumberOfCsIEvents() const
{
  return( theNumberOfCsIEvents );
}

inline Tint BtRunSummary::GetNumberOfScalerEvents() const
{
  return( theNumberOfScalerEvents );
}

inline Tint BtRunSummary::GetNumberOfAllEvents() const
{
  return( theNumberOfAllEvents );
}

inline const TRunInformationTable& BtRunSummary::GetRunInformationTable() const
{
  return( theRunInformationTable );
}

inline const Tstring& BtRunSummary::GetRunBeginTime() const
{
  return( theRunBeginTime );
}

inline const Tstring& BtRunSummary::GetRunEndTime() const
{
  return( theRunEndTime );
}

inline Tvoid BtRunSummary::SetRunID( Tint runid )
{
  theRunID = runid;
  return;
}

inline Tvoid BtRunSummary::SetRecordName( const Tstring& recname )
{
  theRecordName = recname;
  return;
}

inline Tvoid BtRunSummary::SetRecordSize( Tint size )
{
  theRecordSize = size;
  return;
}

inline Tvoid BtRunSummary::SetNumberOfCsIEvents( Tint nevents )
{
  theNumberOfCsIEvents = nevents;
  return;
}

inline Tvoid BtRunSummary::SetNumberOfScalerEvents( Tint nevents )
{
  theNumberOfScalerEvents = nevents;
  return;
}

inline Tvoid BtRunSummary::SetNumberOfAllEvents( Tint nevents )
{
  theNumberOfAllEvents = nevents;
  return;
}

inline Tvoid BtRunSummary::SetRunInformationTable( const TRunInformationTable& table )
{
  theRunInformationTable = table;
  return;
}

inline Tvoid BtRunSummary::SetRunBeginTime( const Tstring& time )
{
  theRunBeginTime = time;
  return;
}

inline Tvoid BtRunSummary::SetRunEndTime( const Tstring& time )
{
  theRunEndTime = time;
  return;
}

inline Tvoid BtRunSummary::SetAccumulatedScaler( const TChannel& scaler )
{
  theAccumulatedScaler = scaler;
  return;
}

inline const TChannel& BtRunSummary::GetAccumulatedScaler() const
{
  return( theAccumulatedScaler );
}

inline Tvoid BtRunSummary::AddAccumulatedScaler( Tint ch, Tint ncounts )
{
  theAccumulatedScaler[ ch ] += ncounts;
  return;
}

#endif
