// ============================================================================
//  $Id: beamtest.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TRunManager.hh"
#include "TTerminalUserInterface.hh"
#include "TCrate.hh"

#include "BtRunAction.hh"
#include "BtEventAction.hh"
#include "BtCrateDefinition.hh"
#include "BtReadoutBookDefinition.hh"
#include "BtEventViewCommand.hh"

int main( int argc, char** argv, char** envv )
{
  TRunManager* manager = new TRunManager( new TTerminalUserInterface() );
  manager -> SetRunAction( new BtRunAction() );
  manager -> SetEventAction( new BtEventAction() );
  manager -> SetCrateDefinition( new BtCrateDefinition() );
  manager -> SetReadoutBookDefinition( new BtReadoutBookDefinition() );


  TCrate* crate = manager -> GetCrate();
  TSoftwareRunInformationModule* runinfo =
    (TSoftwareRunInformationModule*)( crate -> GetModule( "Run Information" ) );
  manager -> SetRunInformationModule( runinfo );
  manager -> SetUserCommand( new BtEventViewCommand() );

  manager -> SessionStart();

  delete manager;

  return( 0 );
}
