// ============================================================================
//  $Id: DummyEventAction.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TEvent.hh"
#include "TRunManager.hh"
#include "TOutputObjectFile.hh"
#include "TSoftwareInterruptRegisterModule.hh"
#include "TSoftwareScalerModule.hh"
#include "TCrate.hh"
#include "TReadoutBook.hh"

#include "DummyEventAction.hh"
#include "DummyRunAction.hh"

DummyEventAction::DummyEventAction()
{;}

DummyEventAction::~DummyEventAction()
{;}

TReadoutList* DummyEventAction::WaitEvent()
{
  TSoftwareInterruptRegisterModule* ir =
    (TSoftwareInterruptRegisterModule*)( theCrate -> GetModule( "Interrupt Register" ) );
  Tbool trigger = Tfalse;
  do {
    if ( ir -> ReadInterruptRegister() == 1 ) {
      trigger = Ttrue;
      break;
    }
  } while ( trigger == Tfalse );

  return( theReadoutBook -> GetReadoutList( "EVENT" ) );
}

Tvoid DummyEventAction::BeginOfEventAction( TEvent& anEvent )
{
  TSoftwareInterruptRegisterModule* ir =
    (TSoftwareInterruptRegisterModule*)( theCrate -> GetModule( "Interrupt Register" ) );
  ir -> SetInterruptMaskRegister( 0x00fe );

  return;
}

Tvoid DummyEventAction::EndOfEventAction( TEvent& anEvent )
{
  DummyRunAction* action =
    (DummyRunAction*)( TRunManager::GetRunManager() -> GetRunAction() );
  TOutputObjectFile* ofile = action -> GetOutputFile();

  *ofile << anEvent.GetDataRecord();

  theCrate -> GetModule( "Event ID" ) -> Update();
  theCrate -> GetModule( "Flash ADC" ) -> Update();
  theCrate -> GetModule( "ADC" ) -> Update();
  theCrate -> GetModule( "Geant4" ) -> Update();

  theCrate -> GetModule( "Interrupt Register" ) -> Clear();

  return;
}
