// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "StBadChannelMap.hh"
#include "TDataRecord.hh"
#include "TDataElement.hh"
#include "TInputObjectFile.hh"
#include "StDataRecordConversion.hh"

StBadChannelMap::StBadChannelMap( const Tstring& filename )
  : StMap( filename ), theOfflineRmsMap( theInputFileName )
{
  // RMS礭ΤХåɥͥˤ
  const TDataMultiplicity& rmsmap = theOfflineRmsMap.GetMap();
  Tdouble threshold = theEnvironmentVariableTable.GetDoubleValue( "ST_BAD_THRESHOLD_RMS" );
  for ( Tint row = 0; row < rmsmap.num_row(); row ++ ) {
    for ( Tint col = 0; col < rmsmap.num_col(); col ++ ) {
      if ( rmsmap[ row ][ col ] > threshold ) {
	theMap[ row ][ col ] = 1.0;
      } 
    }
  }


  // overflow,underflowޤˤΤХåɥͥˤ
  const StOfflineDarkAverageMap& ave = theOfflineRmsMap.GetOfflineDarkAverageMap();
  const TDataMultiplicity& cntmap = ave.GetCounterMap();
  Tdouble needevent =
    ave.GetNumberOfFrames() / theEnvironmentVariableTable.GetDoubleValue( "ST_BAD_OVERFLOW" );
  for ( Tint row = 0; row < cntmap.num_row(); row ++ ) {
    for ( Tint col = 0; col < cntmap.num_col(); col ++ ) {
      if ( cntmap[ row ][ col ] < needevent ) {
	theMap[ row ][ col ] = 1.0;
      } 
    }
  }

}

StBadChannelMap::~StBadChannelMap()
{;}

Tbool StBadChannelMap::IsBadChannel( Tint row, Tint col ) const
{
  if ( row < 0 || row > theNumberOfVerticalPixels - 1 ) {
    Tcerr << "StBadChannelMap::IsBadChannel(): invalid row." << Tendl;
    return( Tfalse );
  }

  if ( col < 0 || col > theNumberOfHorizontalPixels - 1 ) {
    Tcerr << "StBadChannelMap::IsBadChannel(): invalid column." << Tendl;
    return( Tfalse );
  }

  if ( theMap[ row ][ col ] == 1.0 ) {
    return( Ttrue );
  } else {
    return( Tfalse );
  }
}

Tbool StBadChannelMap::IsGoodChannel( Tint row, Tint col ) const
{
  if ( row < 0 || row > theNumberOfVerticalPixels - 1 ) {
    Tcerr << "StBadChannelMap::IsGoodChannel(): invalid row." << Tendl;
    return( Tfalse );
  }

  if ( col < 0 || col > theNumberOfHorizontalPixels - 1 ) {
    Tcerr << "StBadChannelMap::IsGoodChannel(): invalid column." << Tendl;
    return( Tfalse );
  }

  if ( theMap[ row ][ col ] == 1.0 ) {
    return( Tfalse );
  } else {
    return( Ttrue );
  }
}

Tvoid StBadChannelMap::SetBadChannel( Tint row, Tint col )
{
  if ( row < 0 || row > theNumberOfVerticalPixels - 1 ) {
    Tcerr << "StBadChannelMap::SetBadChannel(): invalid row." << Tendl;
    return;
  }

  if ( col < 0 || col > theNumberOfHorizontalPixels - 1 ) {
    Tcerr << "StBadChannelMap::SetBadChannel(): invalid column." << Tendl;
    return;
  }

  theMap[ row ][ col ] = 1.0;

  return;
}

Tvoid StBadChannelMap::SetGoodChannel( Tint row, Tint col )
{
  if ( row < 0 || row > theNumberOfVerticalPixels - 1 ) {
    Tcerr << "StBadChannelMap::SetGoodChannel(): invalid row." << Tendl;
    return;
  }

  if ( col < 0 || col > theNumberOfHorizontalPixels - 1 ) {
    Tcerr << "StBadChannelMap::SetGoodChannel(): invalid column." << Tendl;
    return;
  }

  theMap[ row ][ col ] = 0.0;

  return;
}

Tint StBadChannelMap::GetNumberOfBadChannels() const
{
  Tint num = 0;
  for ( Tint row = 0; row < theMap.num_row(); row ++ ) {
    for ( Tint col = 0; col < theMap.num_col(); col ++ ) {
      if ( theMap[ row ][ col ] == 1.0 ) {
	num ++;
      }
    }
  }
  return( num );
}

Tint StBadChannelMap::GetNumberOfGoodChannels() const
{
  Tint num = 0;
  for ( Tint row = 0; row < theMap.num_row(); row ++ ) {
    for ( Tint col = 0; col < theMap.num_col(); col ++ ) {
      if ( theMap[ row ][ col ] == 0.0 ) {
	num ++;
      }
    }
  }
  return( num );
}
