// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __STBADCHANNELMAP_HH
#define __STBADCHANNELMAP_HH

#include "Tglobals.h"
#include "StMap.hh"
#include "StOfflineRmsMap.hh"

class StBadChannelMap
  : public StMap
{

  private:
    StOfflineRmsMap theOfflineRmsMap;

  public:
    StBadChannelMap( const Tstring& filename );
    ~StBadChannelMap();

  public:
    const StOfflineRmsMap& GetOfflineRmsMap() const;

  public:
    Tbool IsBadChannel( Tint row, Tint col ) const;
    Tbool IsGoodChannel( Tint row, Tint col ) const;
    Tvoid SetBadChannel( Tint row, Tint col );
    Tvoid SetGoodChannel( Tint row, Tint col );
    Tint GetNumberOfBadChannels() const;
    Tint GetNumberOfGoodChannels() const;

};

inline const StOfflineRmsMap& StBadChannelMap::GetOfflineRmsMap() const
{
  return( theOfflineRmsMap );
}

#endif
