// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __STCTISOLUTION_HH
#define __STCTISOLUTION_HH

#include "Tglobals.h"
#include "StSinglePixelList.hh"

class StCtiSolution
{

  private:
    StSinglePixelList theSinglePixelList;
    Tdouble theHorizontalCTI;
    Tdouble theVerticalCTI;
    Tdouble theInitialValue;
    Tdouble theErrorOfHorizontalCTI;
    Tdouble theErrorOfVerticalCTI;
    Tdouble theErrorOfInitialValue;

  public:
    StCtiSolution( const StSinglePixelList& list );
    ~StCtiSolution();

  private:
    Tvoid resolve();
    Tvoid resolveError();

  public:
    const StSinglePixelList& GetSinglePixelList() const;
    Tdouble GetHorizontalCTI() const;
    Tdouble GetVerticalCTI() const;
    Tdouble GetInitialValue() const;
    Tdouble GetErrorOfHorizontalCTI() const;
    Tdouble GetErrorOfVerticalCTI() const;
    Tdouble GetErrorOfInitialValue() const;

};

inline const StSinglePixelList& StCtiSolution::GetSinglePixelList() const
{
  return( theSinglePixelList );
}

inline Tdouble StCtiSolution::GetHorizontalCTI() const
{
  return( theHorizontalCTI );
}

inline Tdouble StCtiSolution::GetInitialValue() const
{
  return( theInitialValue );
}

inline Tdouble StCtiSolution::GetVerticalCTI() const
{
  return( theVerticalCTI );
}

inline Tdouble StCtiSolution::GetErrorOfHorizontalCTI() const
{
  return( theErrorOfHorizontalCTI );
}

inline Tdouble StCtiSolution::GetErrorOfInitialValue() const
{
  return( theErrorOfInitialValue );
}

inline Tdouble StCtiSolution::GetErrorOfVerticalCTI() const
{
  return( theErrorOfVerticalCTI );
}

#endif
