// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "StDataRecordConversion.hh"
#include "TDataRecord.hh"
#include "TDataElement.hh"

StDataRecordConversion::StDataRecordConversion()
  : StMap( "" ), theConversionSuccess( Tfalse )
{;}

StDataRecordConversion::~StDataRecordConversion()
{;}

TDataMultiplicity& StDataRecordConversion::Convert( const TDataRecord& record )
{
  Tstring fadcidset[ 3 ] = { "EVENT", "ADC", "0" };
  TDataElement e;
  if ( record.FindDataElement( fadcidset, e ) ) {
    Tshort* data = e.GetShortData();
    Tint ndata = e.GetNumberOfPrimitives();
    FillMap( data, ndata );
    theConversionSuccess = Ttrue;
  } else {
    theConversionSuccess = Tfalse;
  }

  return( theMap );
}
