// ============================================================================
//  $Id: StEventAction.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TRunManager.hh"
#include "TOutputObjectFile.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TCrate.hh"
#include "TReadoutBook.hh"
#include "TVmeMpx201aModule.hh"
#include "TVmeRpv130Module.hh"

#include "StEventAction.hh"
#include "StRunAction.hh"
#include "StRunSummary.hh"

StEventAction::StEventAction()
{;}

StEventAction::~StEventAction()
{;}

TReadoutList* StEventAction::WaitEvent()
{
  TVmeMpx201aModule* mpx201a =
    (TVmeMpx201aModule*)( theCrate -> GetModule( "mpx201a" ) );
  TVmeRpv130Module* rpv130 =
    (TVmeRpv130Module*)( theCrate -> GetModule( "rpv130" ) );
  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tint veto = envtable.GetIntegerValue( "ST_RPV130_OUT_VETO" );
  Tint open = envtable.GetIntegerValue( "ST_RPV130_OUT_OPEN" );

  Tbool trigger = Tfalse;

  do {
    if ( mpx201a -> IsMemoryBlockFull() ) {
      trigger = Ttrue;
    } else {
      continue;
    }
  } while ( trigger == Tfalse );

  rpv130 -> LevelUp( veto );
  rpv130 -> Pulse( open );

  //mpx201a -> SetBufferOrientation( 1 );
  return( theReadoutBook -> GetReadoutList( "EVENT" ) );
}

Tvoid StEventAction::BeginOfEventAction( TEvent& anEvent )
{
  TVmeMpx201aModule* mpx201a =
    (TVmeMpx201aModule*)( theCrate -> GetModule( "mpx201a" ) );
  TVmeRpv130Module* rpv130 =
    (TVmeRpv130Module*)( theCrate -> GetModule( "rpv130" ) );

  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tint veto = envtable.GetIntegerValue( "ST_RPV130_OUT_VETO" );

  mpx201a -> EnableAcquisition();

  rpv130 -> LevelDown( veto );

  return;
}

Tvoid StEventAction::EndOfEventAction( TEvent& anEvent )
{
  StRunAction* action =
    (StRunAction*)( TRunManager::GetRunManager() -> GetRunAction() );
  TOutputObjectFile* ofile = action -> GetOutputFile();

  TVmeMpx201aModule* mpx201a =
    (TVmeMpx201aModule*)( theCrate -> GetModule( "mpx201a" ) );
  TVmeRpv130Module* rpv130 =
    (TVmeRpv130Module*)( theCrate -> GetModule( "rpv130" ) );


  TDataRecord record = anEvent.GetDataRecord();
  *ofile << record;

  fillEventInformation( record );
  theCrate -> Update( "event" );

  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tint stop = envtable.GetIntegerValue( "ST_RPV130_OUT_STOP" );

  mpx201a -> NextEventProcedure();
  rpv130 -> Pulse( stop );
  return;
}

Tvoid StEventAction::fillEventInformation( const TDataRecord& record )
{
  StRunAction* action = (StRunAction*)( theRunManager -> GetRunAction() );
  StRunSummary* summary = action -> GetRunSummary();
  Tint nevent = summary -> GetNumberOfEvents();
  summary -> SetNumberOfEvents( ++ nevent );

  return;
}
