// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __STMAP_HH
#define __STMAP_HH

#include "Tglobals.h"
#include "TDataMultiplicity.hh"
#include "TEnvironmentVariableTable.hh"

enum Tpixel_t { tEffective, tHoc, tIgnore, tEndOfHoc };

class StMap
{

  protected:
    TEnvironmentVariableTable theEnvironmentVariableTable;
    Tint theNumberOfHorizontalPixels;
    Tint theNumberOfVerticalPixels;
    Tint theRateOfVerticalShift;
    Tint theNumberOfHorizontalOverClockPixels;
    Tstring theInputFileName;
    Tdouble theHOCbuffer;
    TDataMultiplicity theMap;

  protected:
    StMap( const Tstring& filename );
    virtual ~StMap();

  public:
    Tint GetNumberOfHorizontalPixels() const;
    Tint GetNumberOfVerticalPixels() const;
    Tint GetRateOfVerticalShift() const;
    const Tstring& GetInputFileName() const;
    const TDataMultiplicity& GetMap() const;
    TDataMultiplicity& GetMap();
    const TEnvironmentVariableTable& GetEnvironmentVariableTable() const;
    TEnvironmentVariableTable& GetEnvironmentVariableTable();

  public:
    Tpixel_t IsThisPixel( Tint dataid ) const;
    virtual Tvoid FillMap( Tshort* data, Tint ndata );

};

inline Tint StMap::GetNumberOfHorizontalPixels() const
{
  return( theNumberOfHorizontalPixels );
}

inline Tint StMap::GetNumberOfVerticalPixels() const
{
  return( theNumberOfVerticalPixels );
}

inline Tint StMap::GetRateOfVerticalShift() const
{
  return( theRateOfVerticalShift );
}

inline const Tstring& StMap::GetInputFileName() const
{
  return( theInputFileName );
}

inline const TDataMultiplicity& StMap::GetMap() const
{
  return( theMap );
}

inline TDataMultiplicity& StMap::GetMap()
{
  return( theMap );
}
inline const TEnvironmentVariableTable& StMap::GetEnvironmentVariableTable() const
{
  return( theEnvironmentVariableTable );
}
inline TEnvironmentVariableTable& StMap::GetEnvironmentVariableTable()
{
  return( theEnvironmentVariableTable );
}

#endif
