// ============================================================================
//  $Id: StMinusHocEventViewCommand.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TRunManager.hh"
#include "TUserInterface.hh"
#include "TOutputObjectFile.hh"

#include "StMinusHocEventViewCommand.hh"
#include "StRunAction.hh"

static const Tstring _name = "/local/minushocview";
static const Tstring _desc = "draw histogram subtracted H.O.C.\n1st: Nbin, 2nd, Xmin, 3rd: Xmax\nexample /local/minushocview 400 0.0 4096.0";

StMinusHocEventViewCommand::StMinusHocEventViewCommand()
  : TCommand( _name, _desc )
{;}

StMinusHocEventViewCommand::~StMinusHocEventViewCommand()
{;}

Tvoid StMinusHocEventViewCommand::Execute( const TstringList& arguments )
{
  Tstring nbin;
  Tstring xmin;
  Tstring xmax;

  if ( arguments.size() != 3 ) {
    ShowCommandDetail();
    Tcout << "set parameters to default value." << Tendl;
    nbin = "400";
    xmin = "0.0";
    xmax = "4096.0";
  } else {
    nbin = arguments[ 0 ];
    xmin = arguments[ 1 ];
    xmax = arguments[ 2 ];
  }

  TUserInterface* ui = theRunManager -> GetUserInterface();
  StRunAction* action = (StRunAction*)( theRunManager -> GetRunAction() );
  Tstring runid = theRunManager -> GetRun().GetRunIDofString();
  Tstring title = Twquote + "H.O.C. subtracted data, run " + runid + Twquote;

  Tstring filename = action -> GetOutputFile() -> GetFileName();
  Tstring com = "/system/shell";
  TstringList args;
  args.push_back( "./../../bin/minushocview" );
  args.push_back( filename );
  args.push_back( title );
  args.push_back( nbin );
  args.push_back( xmin );
  args.push_back( xmax );
  args.push_back( "&" );

  ui -> ExecuteCommand( com, args );

  return;
}
