// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "StOfflineRmsMap.hh"
#include "StOfflineDarkAverageMap.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TDataMultiplicity.hh"
#include "TInputObjectFile.hh"

StOfflineRmsMap::StOfflineRmsMap( const Tstring& filename )
  : StMap( filename ), theOfflineDarkAverageMap( theInputFileName )
{
  const TDataMultiplicity& avemap = theOfflineDarkAverageMap.GetMap();

  Tstring fadcidset[ 3 ] = { "EVENT", "ADC", "0" };
  TInputObjectFile ifile( theInputFileName );
  TDataRecord r;
  Tint nframe = 0;

  TDataMultiplicity mapbuf( theNumberOfVerticalPixels, theNumberOfHorizontalPixels, 0 );
  TDataMultiplicity diff( theNumberOfVerticalPixels, theNumberOfHorizontalPixels, 0 );

  while ( ( ifile >> r ) != 0 ) {
    TDataElement e;
    if ( r.FindDataElement( fadcidset, e ) ) {
      Tshort* data = e.GetShortData();
      Tint ndata = e.GetNumberOfPrimitives();
      FillMap( data, ndata );
      diff = theMap - avemap;
      for ( Tint row = 0; row < diff.num_row(); row ++ ) {
	for ( Tint col = 0; col < diff.num_col(); col ++ ) {
	  diff[ row ][ col ] = pow( diff[ row ][ col ], 2.0 );
	}
      }
      mapbuf += diff;
      nframe ++;
    } else {
      continue;
    }
  }

  theMap = mapbuf / nframe;

  for ( Tint row = 0; row < theMap.num_row(); row ++ ) {
    for ( Tint col = 0; col < theMap.num_col(); col ++ ) {
      theMap[ row ][ col ] = sqrt( theMap[ row ][ col ] );
    }
  }

}

StOfflineRmsMap::~StOfflineRmsMap()
{;}
