// ============================================================================
//  $Id: StRunAction.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TOutputObjectFile.hh"
#include "TRun.hh"
#include "TReadoutList.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TReadoutBook.hh"
#include "TCrate.hh"
#include "TRunManager.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TSoftwareScalerModule.hh"
#include "TEnvironmentVariableTable.hh"
#include "TVmeRpv130Module.hh"

#include "StRunAction.hh"
#include "StRunSummary.hh"

StRunAction::StRunAction()
  : theOutputFile( 0 ), theRunSummary( 0 ), theOutputHtml()
{;}

StRunAction::~StRunAction()
{;}

Tvoid StRunAction::BeginOfRunAction( TRun& aRun )
{
  Tstring drecfile;
  Tstring htmlfile;
  setFileName( aRun.GetRunID(), drecfile, htmlfile );

  theOutputFile = new TOutputObjectFile( drecfile );
  Tcout << "event data outputs into " << drecfile << Tendl;

  theCrate -> Initialize( "run begin" );

  TSoftwareScalerModule* runid =
    (TSoftwareScalerModule*)( theCrate -> GetModule( "runid" ) );
  runid -> SetData( 0, aRun.GetRunID() );

  TDataRecord record =
    theReadoutBook -> GetReadoutList( "RUN BEGIN" ) -> Read();
  *theOutputFile << record;

  theOutputHtml.Open( htmlfile );
  Tcout << "run summary outputs into " << htmlfile << Tendl;
  theRunSummary = new StRunSummary();
  fillRunBeginInformation( record );

  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tint veto = envtable.GetIntegerValue( "ST_RPV130_OUT_VETO" );
  Tint stop = envtable.GetIntegerValue( "ST_RPV130_OUT_STOP" );
  TVmeRpv130Module* rpv130 =
    (TVmeRpv130Module*)( theCrate -> GetModule( "rpv130" ) );

  rpv130 -> Pulse( stop );
  rpv130 -> LevelUp( veto );

  return;
}

Tvoid StRunAction::EndOfRunAction( TRun& aRun )
{
  TDataRecord record =
    theReadoutBook -> GetReadoutList( "RUN END" ) -> Read();
  *theOutputFile << record;

  fillRunEndInformation( record );
  fillHtmlFile();
  theOutputHtml.Close();

  Tstring htmlfile = theOutputHtml.GetFileName();
  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tint autoprint = envtable.GetIntegerValue( "ST_AUTO_PRINT" );
  if ( autoprint ) {
    // http://www.tdb.uu.se/~jan/html2ps.html
    Tstring command = "html2ps " + htmlfile + " | lpr";
    system( command.c_str() );
  }

  delete theRunSummary;
  delete theOutputFile;
  theRunSummary = 0;
  theOutputFile = 0;


  return;
}

Tvoid StRunAction::FinalOfRunAction( TRun& aRun )
{
  Tcout << "final action is called, but nothing to do." << Tendl;
  Tcout << "process is going to terminate." << Tendl;
  return;
}

Tvoid StRunAction::setFileName( Tint runid, Tstring& drecfile, Tstring& htmlfile )
{
  static const Tstring drecext = ".drec";
  static const Tstring htmlext = ".html";

  Tstring filehead = "run";
  Tstring runidstr = itostr( runid );

  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();

  Tstring drecdir = envtable.GetEnvironmentValue( "ST_RECORD_DIR" );
  Tstring htmldir = envtable.GetEnvironmentValue( "ST_SUMMARY_DIR" );
  Tint overwrite = envtable.GetIntegerValue( "ST_OVERWRITE_ENABLE" );


  if ( runid < 10 ) {
    filehead += "00";
  } else if ( runid < 100 ) {
    filehead += "0";
  }

  drecfile = drecdir + Tslash + filehead + runidstr + drecext;
  htmlfile = htmldir + Tslash + filehead + runidstr + htmlext;

  if ( overwrite == 0 ) {
    if ( isexist( drecfile ) ) {
      Tcout << "already exist " << drecfile << "." << Tendl;
      drecfile = drecdir + Tslash + "TEMP" + filehead + runidstr + drecext;
    }
    if ( isexist( htmlfile ) ) {
      Tcout << "already exist " << htmlfile << "." << Tendl;
      htmlfile = htmldir + Tslash + "TEMP" + filehead + runidstr + htmlext;
    }
  }
  

  return;
}

// Tbool StRunAction::IsExist( const Tstring& filename ) const
// {
//   TFileStream* fp = fopen( filename.c_str(), "r" );
//   if ( fp == 0 ) {
//     return( Tfalse );
//   } else {
//     fclose( fp );
//     return( Ttrue );
//   }
// }

Tvoid StRunAction::fillRunBeginInformation( const TDataRecord& record )
{
  static Tstring runidset[ 3 ] = { "INFO", "RUN ID", "0" };
  static Tstring clockset[ 3 ] = { "INFO", "CLOCK", "0" };

  TDataElement runid;
  TDataElement clock;
  record.FindDataElement( runidset, runid );
  record.FindDataElement( clockset, clock );

  theRunSummary -> SetRecordName( theOutputFile -> GetFileName() );
  theRunSummary -> SetRunID( *( runid.GetIntData() ) );
  theRunSummary -> SetRunBeginTime( *( clock.GetStringData() ) );

  return;
}

Tvoid StRunAction::fillRunEndInformation( const TDataRecord& record )
{
  static Tstring clockset[ 3 ] = { "INFO", "CLOCK", "0" };
  TDataElement clock;
  record.FindDataElement( clockset, clock );

  TRunInformationTable table = theRunManager -> GetRunInformationModule() -> GetRunInformationTable();
  theRunSummary -> SetRunInformationTable( table );
  theRunSummary -> SetRunEndTime( *( clock.GetStringData() ) );
  theRunSummary -> SetRecordSize( theOutputFile -> GetTotalDataSize() );

  return;
}

Tvoid StRunAction::fillHtmlFile()
{
  TRunInformationTable table = theRunSummary -> GenerateRunSummaryTable();
  Tstring title = "Run Summary #" + ( theRunManager -> GetRun() ).GetRunIDofString();

  theOutputHtml.SetTitle( title );
  theOutputHtml.SetInformationTable( table );

  theOutputHtml << TOutputHtmlFileStream::tHeader << Tendl;
  theOutputHtml << TOutputHtmlFileStream::tTable << Tendl;
  theOutputHtml << TOutputHtmlFileStream::tFooter << Tendl;

  return;
}
