// ============================================================================
//  $Id: StRunSummary.hh,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __STRUNSUMMARY_HH
#define __STRUNSUMMARY_HH

#include "TRunInformationTable.hh"
#include "TChannel.hh"

class StRunSummary
{

  private:
    Tint theRunID;
    Tstring theRecordName;
    Tint theRecordSize;
    Tint theNumberOfEvents;
    TRunInformationTable theRunInformationTable;
    Tstring theRunBeginTime;
    Tstring theRunEndTime;

  public:
    StRunSummary();
    ~StRunSummary();

  public:
    TRunInformationTable GenerateRunSummaryTable() const;
    Tvoid Initialize();

  public:
    Tint GetRunID() const;
    const Tstring& GetRecordName() const;
    Tint GetRecordSize() const;
    Tint GetNumberOfEvents() const;
    const TRunInformationTable& GetRunInformationTable() const;
    const Tstring& GetRunBeginTime() const;
    const Tstring& GetRunEndTime() const;
    Tvoid SetRunID( Tint runid );
    Tvoid SetRecordName( const Tstring& recname );
    Tvoid SetRecordSize( Tint size );
    Tvoid SetNumberOfEvents( Tint nevents );
    Tvoid SetRunInformationTable( const TRunInformationTable& table );
    Tvoid SetRunBeginTime( const Tstring& time );
    Tvoid SetRunEndTime( const Tstring& time );

};

inline Tint StRunSummary::GetRunID() const
{
  return( theRunID );
}

inline const Tstring& StRunSummary::GetRecordName() const
{
  return( theRecordName );
}

inline Tint StRunSummary::GetRecordSize() const
{
  return( theRecordSize );
}

inline Tint StRunSummary::GetNumberOfEvents() const
{
  return( theNumberOfEvents );
}

inline const TRunInformationTable& StRunSummary::GetRunInformationTable() const
{
  return( theRunInformationTable );
}

inline const Tstring& StRunSummary::GetRunBeginTime() const
{
  return( theRunBeginTime );
}

inline const Tstring& StRunSummary::GetRunEndTime() const
{
  return( theRunEndTime );
}

inline Tvoid StRunSummary::SetRunID( Tint runid )
{
  theRunID = runid;
  return;
}

inline Tvoid StRunSummary::SetRecordName( const Tstring& recname )
{
  theRecordName = recname;
  return;
}

inline Tvoid StRunSummary::SetRecordSize( Tint size )
{
  theRecordSize = size;
  return;
}

inline Tvoid StRunSummary::SetNumberOfEvents( Tint nevents )
{
  theNumberOfEvents = nevents;
  return;
}

inline Tvoid StRunSummary::SetRunInformationTable( const TRunInformationTable& table )
{
  theRunInformationTable = table;
  return;
}

inline Tvoid StRunSummary::SetRunBeginTime( const Tstring& time )
{
  theRunBeginTime = time;
  return;
}

inline Tvoid StRunSummary::SetRunEndTime( const Tstring& time )
{
  theRunEndTime = time;
  return;
}

#endif
