// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __STSINGLEPIEL_HH
#define __STSINGLEPIEL_HH

#include "Tglobals.h"

class StSinglePixel
{

  protected:
    Tint theHorizontalID;
    Tint theVerticalID;
    Tdouble theSignal;
    Tdouble theDark;
    Tdouble theRms;

  public:
    StSinglePixel( Tint h = 0, Tint v = 0, Tdouble signal = 0.0, Tdouble dark = 0.0, Tdouble rms = 0.0 );
    StSinglePixel( const StSinglePixel& right );
    ~StSinglePixel();

  public:
    const StSinglePixel& operator=( const StSinglePixel& right );
    Tbool operator==( const StSinglePixel& right ) const;
    Tbool operator!=( const StSinglePixel& right ) const;

  public:
    friend Tostream& operator<<( Tostream& tos, const StSinglePixel& right );
    friend Tistream& operator>>( Tistream& tis, StSinglePixel& right );

  public:
    Tint GetHorizontalID() const;
    Tint GetVerticalID() const;
    Tdouble GetSignal() const;
    Tdouble GetDark() const;
    Tdouble GetRms() const;
    Tvoid SetHorizontalID( Tint id );
    Tvoid SetVerticalID( Tint id );
    Tvoid SetSignal( Tdouble signal );
    Tvoid SetDark( Tdouble dark );
    Tvoid SetRms( Tdouble rms );

};

inline Tint StSinglePixel::GetHorizontalID() const
{
  return( theHorizontalID );
}

inline Tint StSinglePixel::GetVerticalID() const
{
  return( theVerticalID );
}

inline Tdouble StSinglePixel::GetSignal() const
{
  return( theSignal );
}

inline Tdouble StSinglePixel::GetDark() const
{
  return( theDark );
}

inline Tdouble StSinglePixel::GetRms() const
{
  return( theRms );
}

inline Tvoid StSinglePixel::SetHorizontalID( Tint id )
{
  theHorizontalID = id;
  return;
}

inline Tvoid StSinglePixel::SetVerticalID( Tint id )
{
  theVerticalID = id;
  return;
}

inline Tvoid StSinglePixel::SetSignal( Tdouble signal )
{
  theSignal = signal;
  return;
}

inline Tvoid StSinglePixel::SetDark( Tdouble dark )
{
  theDark = dark;
  return;
}

inline Tvoid StSinglePixel::SetRms( Tdouble rms )
{
  theRms = rms;
  return;
}

#endif
