// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "StSinglePixelInterface.hh"
#include "StSinglePixel.hh"
#include "StBadChannelMap.hh"
#include "TInputObjectFile.hh"
#include "TDataRecord.hh"
#include "TDataElement.hh"
#include "StDataRecordConversion.hh"

StSinglePixelInterface::StSinglePixelInterface( const Tstring& filename )
  : theSinglePixelList(), theBadChannelMap( 0 )
{
  Tifstream tifs;
  tifs.open( filename.c_str() );
  if ( !( tifs.good() ) || !( tifs.is_open() ) ) {
    Tcerr << "fail to open a file " << filename << "." << Tendl;
    exit( -1 );
  }

  theSinglePixelList.clear();
  while ( !( tifs.eof() ) ) {
    StSinglePixel sp;    
    tifs >> sp;
    if ( tifs.fail() ) {
      break;
    } else {
      theSinglePixelList.push_back( sp );
    }
  }
  tifs.close();
}

StSinglePixelInterface::StSinglePixelInterface( const Tstring& dark, const Tstring& source )
  : theSinglePixelList(), theBadChannelMap( 0 )
{
  theBadChannelMap = new StBadChannelMap( dark );

  StDataRecordConversion conversion;
  TDataRecord r;
  TInputObjectFile ifile( source );
  while ( ( ifile >> r ) != 0 ) {
    const TDataMultiplicity& map = conversion.Convert( r );
    if ( conversion.IsSuccess() ) {
      for ( Tint row = 0; row < map.num_row(); row ++ ) {
	for ( Tint col = 0; col < map.num_col(); col ++ ) {
	  if ( isThisOverThreshold( map, row, col ) && isThisSinglePixel( map, row, col ) ) {
	    Tint h = col;
	    Tint v = row;
	    Tdouble dark = ( theBadChannelMap -> GetOfflineRmsMap().GetOfflineDarkAverageMap().GetMap() )[ row ][ col ];
	    Tdouble signal = map[ row ][ col ] - dark;
	    Tdouble rms = ( theBadChannelMap -> GetOfflineRmsMap().GetMap() )[ row ][ col ];
	    StSinglePixel sp( h, v, signal, dark, rms );
	    theSinglePixelList.push_back( sp );
	  }
	}
      }
    }
  }
}

StSinglePixelInterface::~StSinglePixelInterface()
{
  if ( theBadChannelMap ) {
    delete theBadChannelMap;
  }
}

Tbool StSinglePixelInterface::isThisOverThreshold( const TDataMultiplicity& map, Tint row, Tint col ) const
{
  Tdouble signaldark = map[ row ][ col ];
  Tdouble dark = ( theBadChannelMap -> GetOfflineRmsMap().GetOfflineDarkAverageMap().GetMap() )[ row ][ col ];
  Tdouble rms = ( theBadChannelMap -> GetOfflineRmsMap().GetMap() )[ row ][ col ];

  Tdouble factor = theBadChannelMap -> GetEnvironmentVariableTable().GetDoubleValue( "ST_SPIXEL_THRESHOLD_SIGMA" );
  Tdouble threshold = dark + ( rms * factor );

  if ( signaldark > threshold ) {
    //Tcout << "DEBUG: " << __FILE__ << " " << __LINE__ << " " << dark << "+" << factor << "*" << rms <<  "=" << threshold << " " << signaldark << Tendl;
    return( Ttrue );
  } else {
    return( Tfalse );
  }
}

Tbool StSinglePixelInterface::isThisSinglePixel( const TDataMultiplicity& map, Tint row, Tint col ) const
{
  if ( isThereOverThresholdAroundHere( map, row, col ) ) {
    return( Tfalse );
  }
  if ( isThereBadChannelAroundHere( row, col ) ) {
    return( Tfalse );
  }
  if ( isThisBadChannel( row, col ) ) {
    return( Tfalse );
  }
  return( Ttrue );
}

Tbool StSinglePixelInterface::isThereOverThresholdAroundHere( const TDataMultiplicity& map, Tint row, Tint col ) const
{
  Tdouble factor = theBadChannelMap -> GetEnvironmentVariableTable().GetDoubleValue( "ST_SPIXEL_NO_AROUND_SIGMA" );
  Tint hpixels = theBadChannelMap -> GetNumberOfHorizontalPixels();
  Tint vpixels = theBadChannelMap -> GetNumberOfVerticalPixels();

  Tdouble signaldark;
  Tdouble rms;
  Tdouble dark;
  Tdouble threshold;
  if ( row > 0 && col > 0 ) {
    signaldark = map[ row - 1 ][ col - 1 ];
    rms = ( theBadChannelMap -> GetOfflineRmsMap().GetMap() )[ row - 1 ][ col - 1 ];
    dark = ( theBadChannelMap -> GetOfflineRmsMap().GetOfflineDarkAverageMap().GetMap() )[ row - 1 ][ col - 1 ];
    threshold = dark + ( rms * factor );
    if ( signaldark > threshold ) {
      return( Ttrue );
    }
  }
  if ( row > 0 ) {
    signaldark = map[ row - 1 ][ col ];
    rms = ( theBadChannelMap -> GetOfflineRmsMap().GetMap() )[ row - 1 ][ col ];
    dark = ( theBadChannelMap -> GetOfflineRmsMap().GetOfflineDarkAverageMap().GetMap() )[ row - 1 ][ col ];
    threshold = dark + ( rms * factor );
    if ( signaldark > threshold ) {
      return( Ttrue );
    }
  }
  if ( row > 0 && col < hpixels - 1 ) {
    signaldark = map[ row - 1 ][ col + 1 ];
    rms = ( theBadChannelMap -> GetOfflineRmsMap().GetMap() )[ row - 1 ][ col + 1 ];
    dark = ( theBadChannelMap -> GetOfflineRmsMap().GetOfflineDarkAverageMap().GetMap() )[ row - 1 ][ col + 1 ];
    threshold = dark + ( rms * factor );
    if ( signaldark > threshold ) {
      return( Ttrue );
    }
  }
  if ( col > 0 ) {
    signaldark = map[ row ][ col - 1 ];
    rms = ( theBadChannelMap -> GetOfflineRmsMap().GetMap() )[ row ][ col - 1 ];
    dark = ( theBadChannelMap -> GetOfflineRmsMap().GetOfflineDarkAverageMap().GetMap() )[ row ][ col - 1 ];
    threshold = dark + ( rms * factor );
    if ( signaldark > threshold ) {
      return( Ttrue );
    }
  }
  if ( col < hpixels - 1 ) {
    signaldark = map[ row ][ col + 1 ];
    rms = ( theBadChannelMap -> GetOfflineRmsMap().GetMap() )[ row ][ col + 1 ];
    dark = ( theBadChannelMap -> GetOfflineRmsMap().GetOfflineDarkAverageMap().GetMap() )[ row ][ col + 1 ];
    threshold = dark + ( rms * factor );
    if ( signaldark > threshold ) {
      return( Ttrue );
    }
  }
  if ( row < vpixels - 1 && col > 0 ) {
    signaldark = map[ row + 1 ][ col - 1 ];
    rms = ( theBadChannelMap -> GetOfflineRmsMap().GetMap() )[ row + 1 ][ col - 1 ];
    dark = ( theBadChannelMap -> GetOfflineRmsMap().GetOfflineDarkAverageMap().GetMap() )[ row + 1 ][ col - 1 ];
    threshold = dark + ( rms * factor );
    if ( signaldark > threshold ) {
      return( Ttrue );
    }
  }
  if ( row < vpixels - 1 ) {
    signaldark = map[ row + 1 ][ col ];
    rms = ( theBadChannelMap -> GetOfflineRmsMap().GetMap() )[ row + 1 ][ col ];
    dark = ( theBadChannelMap -> GetOfflineRmsMap().GetOfflineDarkAverageMap().GetMap() )[ row + 1 ][ col ];
    threshold = dark + ( rms * factor );
    if ( signaldark > threshold ) {
      return( Ttrue );
    }
  }
  if ( row < vpixels - 1 && col < hpixels - 1 ) {
    signaldark = map[ row + 1 ][ col + 1 ];
    rms = ( theBadChannelMap -> GetOfflineRmsMap().GetMap() )[ row + 1 ][ col + 1 ];
    dark = ( theBadChannelMap -> GetOfflineRmsMap().GetOfflineDarkAverageMap().GetMap() )[ row + 1 ][ col + 1 ];
    threshold = dark + ( rms * factor );
    if ( signaldark > threshold ) {
      return( Ttrue );
    }
  }
  return( Tfalse );
}

Tbool StSinglePixelInterface::isThereBadChannelAroundHere( Tint row, Tint col ) const
{
  Tint colmax = theBadChannelMap -> GetNumberOfHorizontalPixels() - 1;
  Tint rowmax = theBadChannelMap -> GetNumberOfVerticalPixels() - 1;

  // 0 1 2
  // 3 Q 4
  // 5 6 7
  if ( row > 0 && col > 0 && theBadChannelMap -> IsBadChannel( row - 1, col - 1 ) ) {
    return( Ttrue );
  }
  if ( row > 0 && theBadChannelMap -> IsBadChannel( row - 1, col ) ) {
    return( Ttrue );
  }

  if ( row > 0 && col < colmax && theBadChannelMap -> IsBadChannel( row - 1, col + 1 ) ) {
    return( Ttrue );
  }
  if ( col > 0 && theBadChannelMap -> IsBadChannel( row, col - 1 ) ) {
    return( Ttrue );
  }
  if ( col < colmax && theBadChannelMap -> IsBadChannel( row, col + 1 ) ) {
    return( Ttrue );
  }
  if ( row < rowmax && col > 0 && theBadChannelMap -> IsBadChannel( row + 1, col - 1 ) ) {
    return( Ttrue );
  }
  if ( row < rowmax && theBadChannelMap -> IsBadChannel( row + 1, col ) ) {
    return( Ttrue );
  }
  if ( row < rowmax && col < colmax && theBadChannelMap -> IsBadChannel( row + 1, col + 1 ) ) {
    return( Ttrue );
  }
  return( Tfalse );
}

Tbool StSinglePixelInterface::isThisBadChannel( Tint row, Tint col ) const
{
  if ( theBadChannelMap -> IsBadChannel( row, col ) ) {
    return( Ttrue );
  } else {
    return( Tfalse );
  }
}
