// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __STSINGLEPIXELINTERFACE_HH
#define __STSINGLEPIXELINTERFACE_HH

#include "Tglobals.h"
#include "StSinglePixelList.hh"
#include "TDataMultiplicity.hh"

class StBadChannelMap;

class StSinglePixelInterface
{

  private:
    StSinglePixelList theSinglePixelList;
    StBadChannelMap* theBadChannelMap;

  public:
    StSinglePixelInterface( const Tstring& filename );
    StSinglePixelInterface( const Tstring& dark, const Tstring& source );
    ~StSinglePixelInterface();

  public:
    const StSinglePixelList& GetSinglePixelList() const;
    StSinglePixelList& GetSinglePixelList();
    StBadChannelMap* GetBadChannelMap() const;

  private:
    Tbool isThisOverThreshold( const TDataMultiplicity& map, Tint row, Tint col ) const;
    Tbool isThisSinglePixel( const TDataMultiplicity& map, Tint row, Tint col ) const;
    Tbool isThereOverThresholdAroundHere( const TDataMultiplicity& map, Tint row, Tint col ) const;
    Tbool isThereBadChannelAroundHere( Tint row, Tint col ) const;
    Tbool isThisBadChannel( Tint row, Tint col ) const;

};

inline const StSinglePixelList& StSinglePixelInterface::GetSinglePixelList() const
{
  return( theSinglePixelList );
}

inline StSinglePixelList& StSinglePixelInterface::GetSinglePixelList()
{
  return( theSinglePixelList );
}

inline StBadChannelMap* StSinglePixelInterface::GetBadChannelMap() const
{
  return( theBadChannelMap );
}

#endif
