// ============================================================================
//  $Id: beamtest.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TRunManager.hh"
#include "TEventManager.hh"
#include "TTerminalUserInterface.hh"
#include "TCrate.hh"

#include "StRunAction.hh"
#include "StEventAction.hh"
#include "StCrateDefinition.hh"
#include "StReadoutBookDefinition.hh"
#include "StPureEventViewCommand.hh"
#include "StMinusHocEventViewCommand.hh"
#include "StDarkRmsViewCommand.hh"

int main( int argc, char** argv, char** envv )
{
  TRunManager* manager = new TRunManager( new TTerminalUserInterface() );
  manager -> GetEventManager() -> SetStackSize( 4 );
  manager -> GetEnvironmentVariableTable().SetEnvironment( "setenvrc" );
  manager -> SetRunAction( new StRunAction() );
  manager -> SetEventAction( new StEventAction() );
  manager -> SetCrateDefinition( new StCrateDefinition() );
  manager -> SetReadoutBookDefinition( new StReadoutBookDefinition() );

  manager -> SetUserCommand( new StPureEventViewCommand() );
  manager -> SetUserCommand( new StMinusHocEventViewCommand() );
  manager -> SetUserCommand( new StDarkRmsViewCommand() );

  manager -> SessionStart();

  delete manager;

  return( 0 );
}
