// ============================================================================
//  $Id: TAnalysisStartCommand.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TAnalysisStartCommand.hh"
#include "TRunManager.hh"
#include "TAnalysisManager.hh"

static const Tstring _name = "/analysis/start";
static const Tstring _desc = "start an analysis.";

TAnalysisStartCommand::TAnalysisStartCommand( TRunManager* runman, TAnalysisManager* anaman )
  : TCommand( runman, _name, _desc ), TAnalysisCommand( anaman )
{;}

TAnalysisStartCommand::~TAnalysisStartCommand()
{;}

Tvoid TAnalysisStartCommand::Execute( const TstringList& arguments )
{
  if ( arguments.empty() ) {
    theAnalysisManager -> StartAnalysis();
  } else {
    for ( Tsize_t i = 0; i < arguments.size(); i ++ )
      theAnalysisManager -> StartAnalysis( arguments[ i ] );
  }
  return;
}
