// ============================================================================
//  $Id: TSourceCommand.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TSourceCommand.hh"
#include "TUserInterface.hh"
#include "TRunManager.hh"

static const Tstring _name = "source";
static const Tstring _desc = "read and set environment from filename.";

TSourceCommand::TSourceCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TSourceCommand::~TSourceCommand()
{;}

Tvoid TSourceCommand::Execute( const TstringList& arguments )
{
  if ( arguments.size() == 1 ) {
    TUserInterface* ui = theRunManager -> GetUserInterface();
    ui -> ExecuteCommand( "setenv", arguments );
  } else {
    ShowCommandDetail();
  }
  return;
}
