// ============================================================================
//  $Id: TDataSegment.hh,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TDATASEGMENT_HH
#define __TDATASEGMENT_HH

#include "Tglobals.h"
#include "TStreamableObject.hh"
#include "TDataElementList.hh"

class TOutputObjectStream;
class TOutputObjectFile;
class TOutputObjectSocket;
class TOutputObjectSharedMemory;

class TDataSegment
  : public TStreamableObject, public TDataElementList
{

  public:
    TDataSegment( const Tstring& id = TunknownID );
    TDataSegment( const TDataSegment& right );
    ~TDataSegment();

  public:
    Tint GetRecordSize();
    Tint Record( TOutputObjectStream* output );
    Tvoid Clear();
    Tint Serialize( Tvoid* buffer );

  public:
    const TDataSegment& operator=( const TDataSegment& right );
    Tbool operator==( const TDataSegment& right ) const;
    Tbool operator!=( const TDataSegment& right ) const;
    friend Tostream& operator<<( Tostream& tos, const TDataSegment& right );

  public:
    Tbool FindDataElement( const Tstring& id, TDataElement& element ) const;
    Tint FindDataElement( const Tstring& id ) const;

  private:
    Tint record( TOutputObjectFile* ofile );
    Tint record( TOutputObjectSocket* osocket );
    Tint record( TOutputObjectSharedMemory* omemory );


};

#endif
