// ============================================================================
//  $Id: TUserInterface.hh,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TUSERINTERFACE_HH
#define __TUSERINTERFACE_HH

#include "Tglobals.h"
#include "TCommandHistory.hh"

class TCommand;

class TUserInterface
{

  protected:
    TCommand** theCommandList;
    Tint theCommandListCapacity;
    Tint theNumberOfCommands;
    Tint theCommandIndex;
    Tofstream theHistoryFileStream;
    Tint theNumberOfColumns;
    Tint theNumberOfLines;
    Tstring theCurrentWorkingDirectory;
    TCommandHistory theCommandHistory;

  public:
    Tint AddCommand( TCommand* command );
    Tint RemoveCommand( Tint index );
    Tvoid ClearCommandList();
    Tbool ResizeCommandList( Tint capacity );
    TCommand* NextCommand();
    TCommand* FindCommand( const Tstring& command );
    TCommand* GetCommand( Tint index );
    TCommand* GetCommand();
    Tvoid ExecuteCommand( const Tstring& command, const TstringList& arguments );
    Tvoid ExecuteCommand( const Tstring& command );
    Tint GetCurrentWorkingDirectoryLevel() const;
    Tbool HasDirecotryInThisDirecotry( const Tstring& directory ) const;

  public:
    Tint GetCommandListCapacity() const;
    Tint GetNumberOfCommands() const;
    Tint GetCommandIndex() const;
    Tvoid SetCommandIndex( Tint index );
    Tofstream& GetHistoryFileStream();
    Tint GetNumberOfColumns() const;
    Tint GetNumberOfLines() const;
    Tvoid SetNumberOfColumns( Tint ncol );
    Tvoid SetNumberOfLines( Tint nline );
    const Tstring& GetCurrentWorkingDirectory() const;
    Tvoid SetCurrentWorkingDirectory( const Tstring& directory );
    const TCommandHistory& GetCommandHistory() const;
    TCommandHistory& GetCommandHistory();
    Tvoid SetCommandHistory( const TCommandHistory& history );

  protected:
    Tvoid free();
    Tvoid allocate( Tint capacity );

  public:
    TUserInterface( const Tstring& history = "history.last" );
    virtual ~TUserInterface();

  public:
    virtual Tbool AcceptCommand() = 0;
    virtual const Tstring& GetInputCommand() = 0;

  public:
    virtual Tvoid NotFoundCommand( const Tstring& commandname ) const;

};

inline Tint TUserInterface::GetCommandListCapacity() const
{
  return( theCommandListCapacity );
}

inline Tint TUserInterface::GetNumberOfCommands() const
{
  return( theNumberOfCommands );
}

inline Tint TUserInterface::GetCommandIndex() const
{
  return( theCommandIndex );
}

inline Tvoid TUserInterface::SetCommandIndex( Tint index )
{
  theCommandIndex = index;
  return;
}

inline Tofstream& TUserInterface::GetHistoryFileStream()
{
  return( theHistoryFileStream );
}

inline Tint TUserInterface::GetNumberOfColumns() const
{
  return( theNumberOfColumns );
}

inline Tint TUserInterface::GetNumberOfLines() const
{
  return( theNumberOfLines );
}

inline Tvoid TUserInterface::SetNumberOfColumns( Tint ncol )
{
  theNumberOfColumns = ncol;
  return;
}

inline Tvoid TUserInterface::SetNumberOfLines( Tint nline )
{
  theNumberOfLines = nline;
  return;
}

inline const Tstring& TUserInterface::GetCurrentWorkingDirectory() const
{
  return( theCurrentWorkingDirectory );
}

inline Tvoid TUserInterface::SetCurrentWorkingDirectory( const Tstring& directory )
{
  theCurrentWorkingDirectory = directory;
  return;
}

inline const TCommandHistory& TUserInterface::GetCommandHistory() const
{
  return( theCommandHistory );
}

inline TCommandHistory& TUserInterface::GetCommandHistory()
{
  return( theCommandHistory );
}

inline Tvoid TUserInterface::SetCommandHistory( const TCommandHistory& history )
{
  theCommandHistory = history;
  return;
}

#endif
