// ============================================================================
//  $Id: TCamacScalerModule.hh,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TCAMACSCALERMODULE_HH
#define __TCAMACSCALERMODULE_HH

#include "Tglobals.h"
#include "TCamacModule.hh"

class TDataSegment;
class TDataElement;

class TCamacScalerModule
  : public TCamacModule
{

  public:
    TCamacScalerModule( TCamacCrateController* cc7x00, Tint slot, Tint nch = 12, Tdata_t datalen = t24bitModule );
    TCamacScalerModule( const TCamacScalerModule& right );
    ~TCamacScalerModule();

  public:
    const TCamacScalerModule& operator=( const TCamacScalerModule& right );
    Tbool operator==( const TCamacScalerModule& right ) const;
    Tbool operator!=( const TCamacScalerModule& right ) const;
    Tvoid FillData( TDataElement& element, Tint channel );

  public:
    Tint Clear();
    Tint Update();
    Tint Initialize();

  public:
    Tint ReadOverflowChannel();
    Tint ClearOverflowChannel();
    Tint IncrementAllChannel();

};

#endif
