// ============================================================================
//  $Id: TSoftwareTimerModule.hh,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TSOFTWARETIMERMODULE_HH
#define __TSOFTWARETIMERMODULE_HH

#include "Tglobals.h"
#include "TSoftwareModule.hh"

class TDataSegment;
class TDataElement;

class TSoftwareTimerModule
  : public TSoftwareModule
{

  public:
    enum { 
      tIntervalTime,
      tCurrentTime, 
      tPreviousTime, 
      tUnit,
      tNumberOfChannels
    };

  private:
    Tdouble theIntervalTime;
    Tdouble theCurrentTime;
    Tdouble thePreviousTime;
    Tstring theUnit;

  public:
    TSoftwareTimerModule( const Tstring& unit = Tmsec, Tint nchannel = tNumberOfChannels );
    TSoftwareTimerModule( const TSoftwareTimerModule& right );
    ~TSoftwareTimerModule();

  public:
    Tint Clear();
    Tint Update();
    Tint Initialize();
    Tvoid FillData( TDataElement& element, Tint channel );

  public:
    Tdouble GetIntervalTime() const;
    Tdouble GetCurrentTime() const;
    Tdouble GetPreviousTime() const;
    const Tstring& GetUnit() const;

    Tvoid SetIntervalTime( Tdouble interval );
    Tvoid SetCurrentTime( Tdouble current );
    Tvoid SetPreviousTime( Tdouble previous );
    Tvoid SetUnit( const Tstring& unit );

  public:
    const TSoftwareTimerModule& operator=( const TSoftwareTimerModule& right );
    Tbool operator==( const TSoftwareTimerModule& right ) const;
    Tbool operator!=( const TSoftwareTimerModule& right ) const;

  private:
    Tvoid setCurrentTime();

};

inline Tdouble TSoftwareTimerModule::GetIntervalTime() const
{
  return( theIntervalTime );
}

inline Tdouble TSoftwareTimerModule::GetCurrentTime() const
{
  return( theCurrentTime );
}

inline Tdouble TSoftwareTimerModule::GetPreviousTime() const
{
  return( thePreviousTime );
}

inline const Tstring& TSoftwareTimerModule::GetUnit() const
{
  return( theUnit );
}

inline Tvoid TSoftwareTimerModule::SetIntervalTime( Tdouble interval )
{
  theIntervalTime = interval;
  return;
}

inline Tvoid TSoftwareTimerModule::SetCurrentTime( Tdouble current )
{
  theCurrentTime = current;
  return;
}

inline Tvoid TSoftwareTimerModule::SetPreviousTime( Tdouble previous )
{
  thePreviousTime = previous;
  return;
}

inline Tvoid TSoftwareTimerModule::SetUnit( const Tstring& unit )
{
  if ( unit == Tsec || unit == Tmsec || unit == Tusec )
    theUnit = unit;
  else
    Tcerr << "TSoftwareTimerModule::SetUnit: invalid unit" << Tendl;
  return;
}

inline Tint TSoftwareTimerModule::Clear()
{
  theIntervalTime = 0.0;
  theCurrentTime = 0.0;
  thePreviousTime = 0.0;
  return( theStatus = tStatusSuccess );
}

inline Tint TSoftwareTimerModule::Update()
{
  setCurrentTime();
  return( theStatus = tStatusSuccess );
}

inline Tint TSoftwareTimerModule::Initialize()
{
  Clear();
  theUnit = Tmsec;
  return( theStatus = tStatusSuccess );
}

#endif
