// ============================================================================
//  $Id: TOutputObjectFile.cc,v 1.2 2003/01/06 11:32:13 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TOutputObjectFile.hh"
#include "TObjectFilter.hh"

TOutputObjectFile::TOutputObjectFile( const Tstring& filename, const Tstring& mode )
  : TObjectFile( filename, mode ), TOutputObjectStream( tFileStream )
{;}

TOutputObjectFile::TOutputObjectFile( TObjectFilter* filter, const Tstring& filename, const Tstring& mode )
  : TObjectFile( filename, mode ), TOutputObjectStream( filter, tFileStream )
{;}

TOutputObjectFile::~TOutputObjectFile()
{;}

Tint TOutputObjectFile::Write( TStreamableObject& object )
{
  theLastDataSize = theDataSize;
  theDataSize = 0;
  if ( HasFilter() ) {
    theDataSize = theObjectFilter -> Filtering( object, this );
  } else {
    theDataSize = object.Record( this );
  }
  theTotalDataSize += theDataSize;
  return( theDataSize );
}
