// ============================================================================
//  $Id: TOutputHtmlFileStream.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TOutputHtmlFileStream.hh"

TOutputHtmlFileStream::TOutputHtmlFileStream()
  : Tofstream(), theInformationTable(), theFileName(), theTitle( "untitled" )
{;}

TOutputHtmlFileStream::TOutputHtmlFileStream( const Tstring& title )
  : Tofstream(), theInformationTable(), theFileName(), theTitle( title )
{;}

TOutputHtmlFileStream::TOutputHtmlFileStream( const Tstring& filename, const TRunInformationTable& table, const Tstring& title )
  : Tofstream( filename.c_str() ), theInformationTable( table ), 
    theFileName( filename ), theTitle( "untitled" )
{;}

TOutputHtmlFileStream::TOutputHtmlFileStream( const TRunInformationTable& table )
  : Tofstream(), theInformationTable( table ), 
    theFileName(), theTitle( "untitled" )
{;}

TOutputHtmlFileStream::TOutputHtmlFileStream( const TRunInformationTable& table, const Tstring& title )
  : Tofstream(), theInformationTable( table ), theFileName(), theTitle( title )
{;}

TOutputHtmlFileStream::TOutputHtmlFileStream( const Tstring& filename, const TRunInformationTable& table )
  : Tofstream( filename.c_str() ), theInformationTable( table ), 
    theFileName( filename ), theTitle( "untitled" )
{;}

TOutputHtmlFileStream::TOutputHtmlFileStream( const Tstring& filename, const Tstring& title )
  : Tofstream( filename.c_str() ), theInformationTable(), 
    theFileName( filename ), theTitle( title )
{;}

TOutputHtmlFileStream::~TOutputHtmlFileStream()
{;}

TOutputHtmlFileStream& TOutputHtmlFileStream::MakeHeaderParts()
{
  (Tofstream&)(*this) << "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">" << Tendl;
  (Tofstream&)(*this) << "<html>" << Tendl;
  (Tofstream&)(*this) << "<head>" << Tendl;
  (Tofstream&)(*this) << "<title>" << theTitle << "</title>" << Tendl;
  (Tofstream&)(*this) << "<meta http-equiv=\"content-type\" content=\"text/html; charset=euc-jp\">" << Tendl;
  (Tofstream&)(*this) << "</head>" << Tendl;
  (Tofstream&)(*this) << "<body>" << Tendl;
  (Tofstream&)(*this) << "<h1>" << theTitle << "</h1>" << Tflush;
  return( *this );
}

TOutputHtmlFileStream& TOutputHtmlFileStream::MakeFooterParts()
{
  (Tofstream&)(*this) << "<p>" << Tendl;
  (Tofstream&)(*this) << "8050 Ikarashi 2-no-chou, Niigata City, 950-2181, Japan<br>" << Tendl;
  (Tofstream&)(*this) << "Phone &amp; Fax: +81-25-262-6138<br>" << Tendl;
  (Tofstream&)(*this) << "<a href=\"mailto:iwai@hep.sc.niigata-u.ac.jp\">iwai@hep.sc.niigata-u.ac.jp</a>" << Tendl;
  (Tofstream&)(*this) << "<hr>" << Tendl;
  (Tofstream&)(*this) << "<div align=right>" << Tendl;
  (Tofstream&)(*this) << "<a href=\"http://www.hep.sc.niigata-u.ac.jp/~iwai/\">Go IWAI</a>" << Tendl;
  (Tofstream&)(*this) << "</div>" << Tendl;
  (Tofstream&)(*this) << "</body>" << Tendl;
  (Tofstream&)(*this) << "</html>" << Tflush;
  return( *this );
}

TOutputHtmlFileStream& operator<<( TOutputHtmlFileStream& tos, TOutputHtmlFileStream::ThtmlStream_t type )
{
  switch ( type ) {

    case TOutputHtmlFileStream::tHeader:
      return( tos.MakeHeaderParts() );

    case TOutputHtmlFileStream::tFooter:
      return( tos.MakeFooterParts() );

    case TOutputHtmlFileStream::tTable:
      return( tos.MakeTable() );

    default:
      return( tos );
  }
}

TOutputHtmlFileStream& TOutputHtmlFileStream::MakeTable()
{
  (Tofstream&)(*this) << "<table border=1 cellpadding=4 width=\"100%\">" << Tendl;

  TstringList itemlist = theInformationTable.GetItemList();
  TstringList valuelist = theInformationTable.GetValueList();
  Tint nrow = theInformationTable.GetNumberOfRows();

  for ( Tint i = 0; i < nrow; i ++ ) {
    (Tofstream&)(*this) << "<tr>" << Tendl;
    (Tofstream&)(*this) << "<td><b>" << (itemlist[ i ]).c_str() << "</b></td>" << Tendl;
    (Tofstream&)(*this) << "<td>" << (valuelist[ i ]).c_str() << "</td>" << Tendl;
    (Tofstream&)(*this) << "</tr>" << Tendl;
  }

  (Tofstream&)(*this) << "</table>" << Tflush;

  return( *this );
}

Tvoid TOutputHtmlFileStream::Open( const Tstring& filename )
{
  if ( !this -> is_open() ) {
    open( filename.c_str() );
    theFileName = filename;
  }
  return;
}

Tvoid TOutputHtmlFileStream::Close()
{
  if ( this -> is_open() ) {
    close();
  }
  return;
}
