// ============================================================================
//  $Id: TSystemClock.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TSystemClock.hh"

static const Tstring _defaultformat = "%Y/%m/%d %a %H:%M:%S %z %Z";

TSystemClock::TSystemClock()
  : theAllocatedTime()
{
  static const Tsize_t max = 256;
  Ttime_t time_now = 0;
  time( &time_now );
  struct tm* tm_now = localtime( &time_now );
  Tchar* s = new Tchar[ max ];

  strftime( s, max, _defaultformat.c_str(), tm_now );
  theAllocatedTime = s;

  delete [] s;
}

TSystemClock::TSystemClock( const TSystemClock& right )
  : theAllocatedTime( right.theAllocatedTime )
{;}

TSystemClock::~TSystemClock()
{;}

const TSystemClock& TSystemClock::operator=( const TSystemClock& right )
{
  theAllocatedTime = right.theAllocatedTime;
  return( *this );
}

Tstring TSystemClock::WhatTimeIsItNow() const
{
  static const Tsize_t max = 256;
  Ttime_t time_now = 0;
  time( &time_now );
  struct tm* tm_now = localtime( &time_now );
  Tchar* s = new Tchar[ max ];

  strftime( s, max, _defaultformat.c_str(), tm_now );
  Tstring now = s;

  delete [] s;

  return( now );
}

Tostream& operator<<( Tostream& tos, const TSystemClock& right )
{
  Tstring now = right.WhatTimeIsItNow();
  tos << "Allocated time: " << right.theAllocatedTime;
  tos << "Now: " << now << Tflush;
  return( tos );
}
