// ============================================================================
//  $Id: ofile.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TOutputObjectFile.hh"
#include "TBenchmark.hh"

#include "testrecord.h"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << " <nevent>" << Tendl;
    return( -1 );
  }
  const Tint nevent = atoi( argv[ 1 ] );
  const Tstring filename = "output.drec";
  TOutputObjectFile ofile( filename );
  Tint datasize = 0;
  Tint nevents = 0;

  TBenchmark bench;
  bench.Start();
  for ( Tint i = 0; i < nevent; i ++ ) {
    TDataRecord record = testrecord( i );
    ofile << record;
    datasize += record.GetRecordSize();
    nevents ++;
  }
  bench.Stop();
  Tcout << bench << Tendl;

  Tcout << nevents << " events, ";
  Tcout << datasize << Tslash << ofile.GetTotalDataSize();
  Tcout << " byte data has been written down " << filename << "." << Tendl;

  return( 0 );
}
