// ============================================================================
//  $Id: osocket.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TOutputObjectSocket.hh"
#include "TBenchmark.hh"

#include "testrecord.h"

int main( int argc, char** argv, char** envv )
{
  enum { exCommand, exHost, exPort, exNumberOfEvents, exNumberOfArguments };
  if ( argc != exNumberOfArguments ) {
    Tcerr << "usage: " << argv[ exCommand ];
    Tcerr << Tspace << "<host>";
    Tcerr << Tspace << "<port>";
    Tcerr << Tspace << "<nevent>";
    Tcerr << Tendl;
    return( -1 );
  }
  const Tstring hostname = argv[ exHost ];
  const Tint port = atoi( argv[ exPort ] );
  const Tint nevent = atoi( argv[ exNumberOfEvents ] );
  TOutputObjectSocket osocket( hostname, port );
  Tint datasize = 0;
  Tint nevents = 0;

  TBenchmark bench;
  bench.Start();
  for ( Tint i = 0; i < nevent; i ++ ) {
    TDataRecord record = testrecord( i );
    osocket << record;
    datasize += record.GetRecordSize();
    nevents ++;
  }
  bench.Stop();
  Tcout << bench << Tendl;

  Tcout << nevents << " events, ";
  Tcout << datasize << Tslash << osocket.GetTotalDataSize();
  Tcout << " byte data has been send to " << hostname << "." << Tendl;

  return( 0 );
}
