// =====================================================================
//  $Id: rs01OFFvsecview.cc,v 1.2 2003/10/06 16:28:15 goiwai Exp $
//  $Name: CLDAQ-1-11-00 $
//  $Log: rs01OFFvsecview.cc,v $
//  Revision 1.2  2003/10/06 16:28:15  goiwai
//  *** empty log message ***
//
//  Revision 1.1  2003/09/17 09:52:26  goiwai
//  ʬ(ɤ߽ФŰľɤ߽Фηв)ͥˤ
//  ƥץåȤޤ.
//  ϻ(H:M:S)Ǥ.
//
//  ޤѤʻͤǤ,5ɬפǤ.
//    1. ID
//    2. ڥǥեؤΥѥ(132Υǡ)
//    3. ӡOFFΥڥǥեؤΥѥ(132Υǡ)
//    4. ڥǥ뤬Ϥ륤٥ID
//    4. ڥǥäߤޤ륤٥ID
//
//  % rs01OFFvsecview 123 ped0.dat ped1.dat 45 678
//  Ȥ, run000123.drec ˤĤƼ¹Ԥޤ.
//  Event ID:0ID:44ޤǤ "ped0.dat"ڥǥȤƻѤޤ.
//  Event ID:679ʹߤΥ٥Ȥˤ "ped1.dat" Ѥޤ.
//  Event ID:45Event ID:678ޤǤϥ٥ȿ㤷ޤ.
//
//  ⤷,ҤȤĤƱڥǥȤä
//  % rs01OFFvsecview 123 ped0.dat ped0.dat(ɤե) 10000(Ǥ) 678(Ŭ)
//  ǥ̤ƤäƱڥǥȤޤ.
//
// =====================================================================
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TEnvironmentVariableTable.hh"
#include "TInputObjectFile.hh"
#include "Trootinit.h"

static const Tstring rcpath = "rs01setup";
static const Tint npin = 32;
static Tint pinpos[ npin ] = {
           3,  4, 5,   6,  7,
      10, 11, 12, 13, 14, 15, 16,
  17, 18, 19, 20, 21, 22, 23, 24,
      26, 27, 28, 29, 30, 31, 32,
           35, 36, 37, 38, 39
};

TInputObjectFile* ifile = 0;
TEnvironmentVariableTable* envtable = 0;
TDataRecord record;
Tdouble vdc[ npin ];
Tint elapsed[ npin ];
Tdouble integrated[ npin ];
Tdouble ped0[ npin ];
Tdouble ped1[ npin ];

TApplication* theApplication = 0;
TCanvas* CVvsec = 0;
static const Tint nx = 8;
static const Tint ny = 5;
static const Tint npadvsec = nx * ny;
TH1D** H1Dvsec;
Tstring htvsec[ npin ];
Tstring hnamevsec[ npin ];

static Tstring fpath, macrof, giff, psf, rootf, dataf, ped0path, ped1path;
static Tint modperiod, pedbegin, pedend, runid;
static Tstring pedbeginclock, pedendclock, runbeginclock, runendclock;

static Tvoid initialize( Tint argc, Tchar** argv );
static Tvoid event();
static Tvoid runbegin();
static Tvoid runend();
static Tdouble getpedestal( Tint ch, Tint eventid );

int main( int argc, char** argv, char** envv )
{
  initialize( argc, argv );

  while ( ifile -> Read( record ) ) {
    Tstring recid = record.GetID();
    if ( recid == "RUN BEGIN" ) {
      runbegin();
      continue;
    } else if ( recid == "EVENT" ) {
      event();
    } else if ( recid == "RUN END" ) {
      runend();
      break;
    } else {
      Tcerr << "unknown tag: " << recid << Tendl;
      break;
    }
    gSystem -> ProcessEvents();
  }

  theApplication -> Terminate();
  return 0;
}

Tvoid initialize( Tint argc, Tchar** argv )
{
  if ( argc != 6 ) {
    Tcerr << "usage: " << argv[ 0 ] << " <run#> <path0> <path1> <begin> <end>" << Tendl;
    Tcout << "ex) " << argv[ 0 ] << " 123 ped0.dat ped1.dat 45 678" << Tendl;
    Tcout << "Run123Ű߻֤ʬ̤ץåȤޤ." << Tendl;
    Tcout << "ڥǥˤ132Υǡե\"ped0.dat\"\"ped1.dat\"ɤߤǻѤޤ." << Tendl;
    Tcout << "Event ID:0Event ID:44ޤǤ\"ped0.dat\"ڥǥȤƻѤޤ." << Tendl;
    Tcout << "Event ID:679ʹߤΥ٥Ȥˤ\"ped1.dat\"ڥǥȤƻѤޤ." << Tendl;
    Tcout << "Event ID:45Event ID:678ޤǤϥ٥ȿ㤷ƥڥǥ뤬ޤ." << Tendl;
    Tcout << Tendl;
    Tcout << "ҤȤĤƱڥǥȤä" << Tendl;
    Tcout << "ex) " << argv[ 0 ] << " 123 ped0.dat ped0.dat(ɤե) 10000(Ǥ) 678(Ŭ)" << Tendl;
    Tcout << "ǥ̤ƤäƱڥǥȤޤ." << Tendl;
    exit( -1 );
  }

  runid = (Tint)strtol( argv[1], 0, 0 );
  Tstring runidstr = itostr( runid );

  ped0path = argv[2];
  ped1path = argv[3];
  pedbegin = (Tint)strtol(argv[4],0,0);
  pedend = (Tint)strtol(argv[5],0,0);



  Tstring htped = "Beam Profile Monitor, Run ID: " + runidstr;
  Tstring htint = "Beam Profile Monitor(Integrated), Run ID: " + runidstr;

  envtable = new TEnvironmentVariableTable ( rcpath );
  Tstring rechead = envtable -> GetEnvironmentValue( "RS01_RECORD_HEAD" );
  Tstring recpath = envtable -> GetEnvironmentValue( "RS01_RECORD_DIR" );
  fpath = recpath + Tslash + rechead + runidstr + ".drec";
  ifile = new TInputObjectFile( fpath );


  rootf = rechead + runidstr + "vsec.root";
  macrof = rechead + runidstr + "vsec.C";
  giff = rechead + runidstr + "vsec.gif";
  psf = rechead + runidstr + "vsec.ps";
  dataf = rechead + runidstr + "vsec.dat";

  modperiod = envtable -> GetIntegerValue( "RS01_UPDATE_PERIOD" );


  // pedestal
  Tifstream ifs;
  ifs.open(ped0path.c_str());
  for ( Tint i = 0; i < npin; i ++ ) {
    ifs >> ped0[i];
  }
  ifs.close();

  ifs.open(ped1path.c_str());
  for ( Tint i = 0; i < npin; i ++ ) {
    ifs >> ped1[i];
  }
  ifs.close();


  theApplication = rootinit();
  TGaxis::SetMaxDigits( 2 );


  CVvsec = new TCanvas( "CVvsec", "Integrated Voltage VS Time", 960, 720 );
  CVvsec -> ToggleEventStatus();
  CVvsec -> Divide( nx, ny );


  H1Dvsec = new TH1D*[npin];
  for ( Tint ch = 0; ch < npin; ch ++ ) {
    htvsec[ ch ] = "Channel: " + itostr( ch, 2 ) + ", Run ID: " + runidstr;
    hnamevsec[ ch ] = "H1Dvsec" + itostr( ch, 2 );

    H1Dvsec[ ch ] = 
      new TH1D( hnamevsec[ ch ].c_str(), htvsec[ ch ].c_str(), 10, 0.0, 10.0 );

    H1Dvsec[ ch ] -> SetStats( 0 );
    H1Dvsec[ ch ] -> GetXaxis() -> SetTimeDisplay( 1 );
    H1Dvsec[ ch ] -> SetMarkerStyle( 1 );
    H1Dvsec[ ch ] -> SetLineColor( 10 );
    H1Dvsec[ ch ] -> SetLineStyle( 0 );
    H1Dvsec[ ch ] -> SetLineWidth( 0 );

    H1Dvsec[ ch ] -> GetXaxis() -> SetNdivisions( 504 );
    H1Dvsec[ ch ] -> GetXaxis() -> SetTimeFormat( "%H:%M:%S" );
    H1Dvsec[ ch ] -> GetXaxis() -> SetTitle( "Time (H:M:S)" );
    H1Dvsec[ ch ] -> GetXaxis() -> CenterTitle();
    H1Dvsec[ ch ] -> GetYaxis() -> SetTitle( "Integrated Voltage (Vsec)" );
    H1Dvsec[ ch ] -> GetYaxis() -> CenterTitle();
    H1Dvsec[ ch ] -> GetYaxis() -> SetNoExponent();

    CVvsec -> cd( pinpos[ ch ] );
    H1Dvsec[ ch ] -> Draw( "pe" );
  }

  return;
}

Tvoid event()
{
  Tint eventid;
  record[ 0 ][ 0 ][ 0 ].StorePrimitive( eventid );
  if ( eventid == pedbegin ) {
    record[1][0][1].StorePrimitive(pedbeginclock);
  }
  if ( eventid == pedend ) {
    record[1][0][1].StorePrimitive(pedendclock);
  }

  for ( Tint ch = 0; ch < npin; ch ++ ) {
    // VDCΥʥåץå
    record[ 1 ][ ch ][ 0 ].StorePrimitive( vdc[ ch ] );

    // ɤߤηвÿ(msec)
    Tdouble secbuf;
    record[ 1 ][ ch ][ 4 ].StorePrimitive(secbuf);

    // msec -> sec
    secbuf /= 1000.0;

    // ڥǥΤȤ
    Tdouble pedbuf = getpedestal( ch, eventid );
    integrated[ ch ] += ( vdc[ch] - pedbuf ) * secbuf;
//     if ( ch == 16 ) {
//       Tcout << "DEBUG" << Ttab;
//       Tcout << "EVENT: " << eventid << Ttab;
//       Tcout << "PED: " << pedbuf << Ttab;
//       Tcout << "VSEC: " << ( vdc[ch] - pedbuf ) * secbuf << Ttab;
//       Tcout << "SUM: " << integrated[ ch ] << Tendl;
//     }

    // 󳫻Ϥηвÿ(sec)
    record[ 1 ][ ch ][ 3 ].StorePrimitive( elapsed[ ch ] );

    // ʬŰ VS 
    H1Dvsec[ ch ] -> SetBinContent( elapsed[ ch ], integrated[ ch ] );

    H1Dvsec[ ch ] -> GetXaxis() -> SetNdivisions( 504 );
    H1Dvsec[ ch ] -> GetXaxis() -> SetTimeFormat( "%H:%M:%S" );
    H1Dvsec[ ch ] -> GetXaxis() -> SetTitle( "Time (H:M:S)" );
    H1Dvsec[ ch ] -> GetXaxis() -> CenterTitle();
    H1Dvsec[ ch ] -> GetYaxis() -> SetTitle( "Integrated Voltage (Vsec)" );
    H1Dvsec[ ch ] -> GetYaxis() -> CenterTitle();
    H1Dvsec[ ch ] -> GetYaxis() -> SetNoExponent();

    H1Dvsec[ ch ] -> SetDrawOption( "pe" );
  }


  // update
  if ( eventid % modperiod == 0 ) {
    for ( Tint i = 0; i < npadvsec; i ++ ) {
      CVvsec -> GetPad(i+1)->Modified();
      CVvsec -> GetPad(i+1)->Update();
    }
  }

  return;
}

Tvoid runbegin()
{
  Tint secbuf;
  record[ 0 ][ 1 ][ 1 ].StorePrimitive( secbuf );
  gStyle -> SetTimeOffset( secbuf );

  for ( Tint ch = 0; ch < npin; ch ++ ) {
    vdc[ch] = 0.0;
    elapsed[ch] = 0;
    integrated[ch] = 0.0;
  }

  pedbeginclock = "----/--/-- --:--:--(undefine)";
  pedendclock = "----/--/-- --:--:--(undefine)";
  record[0][1][0].StorePrimitive(runbeginclock);
  runendclock = "----/--/-- --:--:--(undefine)";
  return;
}

Tvoid runend()
{
  record[0][1][0].StorePrimitive(runendclock);

  Tofstream ofs(dataf.c_str());
  ofs << "// RUN ID: " << runid << Tendl;
  ofs << "// RUN BEGIN: " << runbeginclock << Tendl;
  ofs << "// RUN END: " << runendclock << Tendl;
  ofs << "// PEDESTAL BEGIN: " << ped0path << Ttab << pedbegin << Ttab << pedbeginclock << Tendl;
  ofs << "// PEDESTAL END: " << ped1path << Ttab << pedend << Ttab << pedendclock << Tendl;
  for ( Tint ch = 0; ch < npin; ch ++ ) {
    ofs << ch << Ttab << H1Dvsec[ch] -> GetMaximum() << Tendl;
  }
  ofs.close();


  // update
  for ( Tint i = 0; i < npadvsec; i ++ ) {
    CVvsec -> GetPad(i+1)->Modified();
    CVvsec -> GetPad(i+1)->Update();
  }


  // printout
  CVvsec -> cd();
  TFile* file = new TFile( rootf.c_str(), "RECREATE", "INTEGRATED VOLTAGE VIEW OFFLINE" );
  for ( Tint ch = 0; ch < npin; ch ++ ) {
    H1Dvsec[ ch ] -> Write();
  }
  CVvsec -> Write();
  file -> Close();

  CVvsec -> Print( giff.c_str() );
  CVvsec -> Print( psf.c_str() );

  return;
}

Tdouble getpedestal( Tint ch, Tint eventid )
{
  if ( eventid >= 0 && eventid < pedbegin ) {
    return ped0[ch];
  } else if ( eventid > pedend ) {
    return ped1[ch];
  } else if ( eventid >= pedbegin && eventid <= pedend ) {
    Tdouble a = (ped1[ch]-ped0[ch])/(Tdouble)(pedend-pedbegin);
    Tdouble b = ped0[ch] - a*(Tdouble)pedbegin;
    //ɤäǤƱ̤ˤʤ뤳Ȥϳǧ
    //Tdouble b = ped1[ch] - a*(Tdouble)pedend;
    return (a*(Tdouble)eventid) + b;
  } else {
    Tcerr << "EVENT: " << eventid << Ttab;
    Tcerr << "BEGIN: " << pedbegin << Ttab;
    Tcerr << "END: " << pedbegin << Tendl;
    exit( -1 );
  }
}
