// =====================================================================
//  $Id: Sw00Geant4ViewCommand.cc,v 1.3 2003/10/06 16:28:16 goiwai Exp $
//  $Name: CLDAQ-1-11-00 $
//  $Log: Sw00Geant4ViewCommand.cc,v $
//  Revision 1.3  2003/10/06 16:28:16  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:15:15  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRunManager.hh"
#include "TUserInterface.hh"
#include "TOutputObjectFile.hh"
#include "TEnvironmentVariableTable.hh"

#include "Sw00Geant4ViewCommand.hh"
#include "Sw00RunAction.hh"

static const Tstring _name = "/local/sw00g4view";
static const Tstring _desc = "view histogram(Geant4)";

Sw00Geant4ViewCommand::Sw00Geant4ViewCommand()
  : TCommand( _name, _desc )
{;}

Sw00Geant4ViewCommand::~Sw00Geant4ViewCommand()
{;}

Tvoid Sw00Geant4ViewCommand::Execute( const TstringList& arguments )
{
  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tstring bindir = envtable.GetEnvironmentValue( "SW00_BIN_DIR" );
  Tstring comname = bindir + Tslash + "sw00g4view";

  TUserInterface* ui = theRunManager -> GetUserInterface();
  Sw00RunAction* action = (Sw00RunAction*)( theRunManager -> GetRunAction() );
  Tstring filename = action -> GetOutputFile() -> GetFileName();
  Tstring com = "/system/shell";
  TstringList args;
  args.push_back( comname );
  args.push_back( filename );
  args.push_back( "&" );

  ui -> ExecuteCommand( com, args );

  return;
}
