// =====================================================================
//  $Id: TSoftwareTimerModule.cc,v 1.6 2003/10/06 17:02:40 goiwai Exp $
//  $Name: CLDAQ-1-11-00 $
//  $Log: TSoftwareTimerModule.cc,v $
//  Revision 1.6  2003/10/06 17:02:40  goiwai
//  *** empty log message ***
//
//  Revision 1.5  2003/07/30 16:19:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TSoftwareTimerModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TSoftwareTimerModule::TSoftwareTimerModule( const Tstring& unit, Tint nchannel )
  : TSoftwareModule( nchannel ), theSystemTimer( unit ), 
    theRealElapsedTimeTotal( 0.0 )
{
  Start();
}

TSoftwareTimerModule::TSoftwareTimerModule( Tint nchannel, const Tstring& unit )
  : TSoftwareModule( nchannel ), theSystemTimer( unit ), 
    theRealElapsedTimeTotal( 0.0 )
{
  Start();
}

TSoftwareTimerModule::TSoftwareTimerModule( const TSoftwareTimerModule& right )
  : TSoftwareModule( right ), 
    theSystemTimer( right.theSystemTimer ),
    theRealElapsedTimeTotal( right.theRealElapsedTimeTotal )
{
  Stop();
  Start();
}

TSoftwareTimerModule::~TSoftwareTimerModule()
{;}

Tint TSoftwareTimerModule::Clear()
{
  theRealElapsedTimeTotal = 0.0;
  return theStatus = tStatusSuccess;
}

Tint TSoftwareTimerModule::Update()
{
  return theStatus = tStatusSuccess;
}

Tint TSoftwareTimerModule::Initialize()
{
  Stop();
  theRealElapsedTimeTotal = 0.0;
  Start();
  return theStatus = tStatusSuccess;
}

Tvoid TSoftwareTimerModule::FillData( TDataElement& element, Tint channel )
{
  Stop();
  if ( channel < 0 || channel >= theNumberOfChannels ) {
    Tcerr << "TSoftwareTimerModule::FillData: invalid ID " << channel << Tendl;
    theStatus = -EFAULT;
    element.FillData( &theStatus, tTypeInt, 1 );
  } else {
    Tdouble dblbuf;
    Tstring strbuf;
    switch( channel ) {
      case tSystemElapsedTime:
        dblbuf = theSystemTimer.GetSystemElapsedTime();
        element.FillData( &dblbuf, tTypeDouble, 1 );
        break;
      case tUserElapsedTime:
        dblbuf = theSystemTimer.GetUserElapsedTime();
        element.FillData( &dblbuf, tTypeDouble, 1 );
        break;
      case tUnit:
        strbuf = theSystemTimer.GetUnit();
        element.FillData( &strbuf, tTypeString, 1 );
        break;
      case tRealElapsedTimeTotal:
        dblbuf = theRealElapsedTimeTotal;
        element.FillData( &dblbuf, tTypeDouble, 1 );
        break;
      case tRealElapsedTime:
      default:
        dblbuf = theSystemTimer.GetRealElapsedTime();
        element.FillData( &dblbuf, tTypeDouble, 1 );
        break;
    }
  }
  Start();
  return;
}

const TSoftwareTimerModule& TSoftwareTimerModule::operator=( const TSoftwareTimerModule& right )
{
  *( (TSoftwareModule*)this ) = *( (TSoftwareModule*)(&right) );
  theSystemTimer = right.theSystemTimer;
  Stop();
  Start();
  return *this;
}

Tbool TSoftwareTimerModule::operator==( const TSoftwareTimerModule& right ) const
{
  Tbool retval = Ttrue;
  retval &= ( *( (TSoftwareModule*)this ) == *( (TSoftwareModule*)(&right) ) );
  retval &= ( theSystemTimer.GetBeginOfRealTime() == right.theSystemTimer.GetBeginOfRealTime() );
  retval &= ( theSystemTimer.GetStatus() == right.theSystemTimer.GetStatus() );
  return retval;
}

Tbool TSoftwareTimerModule::operator!=( const TSoftwareTimerModule& right ) const
{
  Tbool retval = Tfalse;
  retval |= ( *( (TSoftwareModule*)this ) != *( (TSoftwareModule*)(&right) ) );
  retval |= ( theSystemTimer.GetBeginOfRealTime() != right.theSystemTimer.GetBeginOfRealTime() );
  retval |= ( theSystemTimer.GetStatus() != right.theSystemTimer.GetStatus() );
  return retval;
}
