// =====================================================================
/*!
//
//  \file TVmeRpv130Module.hh
//  \brief This file contains the TVmeRpv130Module class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TVmeRpv130Module.hh,v 1.4 2003/11/03 08:35:13 goiwai Exp $
//  $Name: CLDAQ-1-11-00 $
//  $Log: TVmeRpv130Module.hh,v $
//  Revision 1.4  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:40  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:12  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef __TVMERPV130MODULE_HH
#define __TVMERPV130MODULE_HH

#include "Tglobals.h"
#include "TVmeModule.hh"

class TDataElement;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TVmeRpv130Module
// \brief This is the TVmeRpv130Module class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TVmeRpv130Module class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup ModulesCategory
*/
class TVmeRpv130Module
  : public TVmeModule
{

  private:
    enum
    {
      LATCH1 = 0x00,
      LATCH2 = 0x02,
      RSFF = 0x04,
      THROUGH = 0x06,
      PULSE = 0x08,
      LEVEL = 0x0a,
      CSR1 = 0x0c,
      CSR2 = 0x0e
    };

  public:
    enum
    {
      tReadoutWithLatch1,
      tReadoutWithLatch2,
      tReadoutWithRSFF,
      tReadoutWithThrough
    };

  private:
    Tint theReadoutMode;
    Tint theLevelStatus;

  public:
    // should be 1 channel module
    TVmeRpv130Module( Toff_t offset, Tint mapsize = 0x1000, Tint nch = 1 );
    TVmeRpv130Module( const TVmeRpv130Module& right );
    ~TVmeRpv130Module();

  public:
    Tint GetReadoutMode() const;
    Tvoid SetReadoutMode( Tint readmode );
    Tint GetLevelStatus() const;
    Tvoid SetLevelStatus( Tint status );

  public:
    const TVmeRpv130Module& operator=( const TVmeRpv130Module& right );
    Tbool operator==( const TVmeRpv130Module& right ) const;
    Tbool operator!=( const TVmeRpv130Module& right ) const;

  public:
    Tint Clear();
    Tint Update();
    Tint Initialize();
    Tvoid FillData( TDataElement& element, Tint channel );

  public:
    Tvoid Pulse();
    Tvoid Pulse( Tint pattern );

    // NIM Signal
    // -xxV: 1, 0V: 0
    // Up -> 1, Down -> 0
    Tvoid Level();
    Tvoid Level( Tint pattern );
    Tvoid LevelUp();
    Tvoid LevelUp( Tint channel );
    Tvoid LevelDown();
    Tvoid LevelDown( Tint channel );
    Tvoid Enable();
    Tvoid Disable();
    TUshort Read();

};

inline Tint TVmeRpv130Module::GetReadoutMode() const
{
  return theReadoutMode;
}

inline Tvoid TVmeRpv130Module::SetReadoutMode( Tint readmode )
{
  theReadoutMode = readmode;
  return;
}

inline Tint TVmeRpv130Module::GetLevelStatus() const
{
  return theLevelStatus;
}

inline Tvoid TVmeRpv130Module::SetLevelStatus( Tint status )
{
  status &= 0x00ff;
  theLevelStatus = status;
  return;
}

#endif
