// =====================================================================
//  $Id: TReadoutBook.cc,v 1.3 2003/10/06 16:39:00 goiwai Exp $
//  $Name: CLDAQ-1-11-00 $
//  $Log: TReadoutBook.cc,v $
//  Revision 1.3  2003/10/06 16:39:00  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:20:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TReadoutBook.hh"
#include "TReadoutList.hh"
#include "TDataRecord.hh"

TReadoutBook::TReadoutBook()
  : theReadoutIndex()
{
  theReadoutIndex.Clear();
}

TReadoutBook::~TReadoutBook()
{
  ClearReadoutBook();
}

Tint TReadoutBook::AddReadoutList( TReadoutList* readoutlist )
{
  Tstring id = readoutlist -> GetID();
  if ( FindReadoutList( id ) != 0 ) {
    Tcerr << "TReadoutBook::AddReadoutList: already exist ReadoutList identified as " << id << "." << Tendl;
  } else {
    theReadoutIndex.AddReadoutList( id, readoutlist );
  }
  return theReadoutIndex.GetSize();
}

Tint TReadoutBook::RemoveReadoutList( Tint index )
{
  Tstring head = "TReadoutBook::RemoveReadoutList: ";
  if ( index < 0 || index >= theReadoutIndex.GetSize() ) {
    Tcerr << head << "invalid index " << index << "." << Tendl;
    return theReadoutIndex.GetSize();
  }
  Tstring id = theReadoutIndex[ index ].GetListID();
  delete ( theReadoutIndex[ index ].GetReadoutList() );
  Tcout << head << "ReadoutList identified as " << id << " was deleted.";
  theReadoutIndex.RemoveReadoutList( index );

  return theReadoutIndex.GetSize();
}

Tint TReadoutBook::RemoveReadoutList( const Tstring& id )
{
  for ( Tint index = 0; index < theReadoutIndex.GetSize(); index ++ ) {
    if ( theReadoutIndex[ index ].GetListID() == id ) {
      RemoveReadoutList( index );
    }
  }
  return theReadoutIndex.GetSize();
}

Tvoid TReadoutBook::ClearReadoutBook()
{
  Tstring head = "TReadoutBook::ClearReadoutBook: ";
  for ( Tint i = 0; i < theReadoutIndex.GetSize(); i ++ ) {
    if ( theReadoutIndex[ i ].GetReadoutList() ) {
      Tstring id = theReadoutIndex[ i ].GetListID();
      delete ( theReadoutIndex[ i ].GetReadoutList() );
      Tcout << head << "ReadoutList identified as " << id << " was deleted." << Tendl;
    }
  }
  theReadoutIndex.Clear();
  return;
}

TReadoutList* TReadoutBook::FindReadoutList( const Tstring& id )
{
  return theReadoutIndex.FindReadoutList( id );
}

TReadoutList* TReadoutBook::GetReadoutList( Tint index )
{
  if ( index < 0 || index >= theReadoutIndex.GetSize() ) {
    Tcerr << "TReadoutBook::GetReadoutList: invalid index " << index << "." << Tendl;
    return 0;
  }
  return theReadoutIndex[ index ].GetReadoutList();
}

TReadoutList* TReadoutBook::GetReadoutList( const Tstring& id )
{
  return FindReadoutList( id );
}

TDataRecord TReadoutBook::Read( const Tstring& id )
{
  TReadoutList* readoutlist = FindReadoutList( id );
  TDataRecord record;
  if ( readoutlist ) {
    record = readoutlist -> Read();
  }
  return record;
}
