// =====================================================================
/*!
//
//  \file TReadoutSection.hh
//  \brief This file contains the TReadoutSection class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TReadoutSection.hh,v 1.4 2003/11/03 08:35:14 goiwai Exp $
//  $Name: CLDAQ-1-11-00 $
//  $Log: TReadoutSection.hh,v $
//  Revision 1.4  2003/11/03 08:35:14  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 16:39:00  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:20:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef __TREADOUTSECTION_HH
#define __TREADOUTSECTION_HH

#include "Tglobals.h"
#include "TReadoutIdentification.hh"
#include "TReadoutSegmentList.hh"

class TDataSection;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TReadoutSection
// \brief This is the TReadoutSection class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TReadoutSection class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup ReadoutCategory
*/
class TReadoutSection
  : public TReadoutIdentification, public TReadoutSegmentList
{

  public:
    TReadoutSection( const Tstring& id = TunknownID );
    TReadoutSection( const TReadoutSection& right );
    ~TReadoutSection();

  public:
    const TReadoutSection& operator=( const TReadoutSection& right );
    Tbool operator==( const TReadoutSection& right ) const;
    Tbool operator!=( const TReadoutSection& right ) const;

  public:
    TDataSection Read();

};

#endif
