// =====================================================================
//  $Id: osocket.cc,v 1.3 2003/10/06 04:03:39 goiwai Exp $
//  $Name: CLDAQ-1-11-00 $
//  $Log: osocket.cc,v $
//  Revision 1.3  2003/10/06 04:03:39  goiwai
//  TArgumentѤ褦ƤΥץޤ.
//
//  Revision 1.2  2003/07/30 16:21:39  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TOutputObjectSocket.hh"
#include "TBenchmark.hh"
#include "TDataRecord.hh"
#include "TOption.hh"
#include "TOptionTable.hh"
#include "TArgument.hh"

int main( int argc, char** argv, char** envv )
{
  TOption opevent( "number-of-events", 1 );
  TOption ophost( "output-host-name", 1 );
  TOption opport( "output-port-number", "p", 1 );
  const Tint noption = 3;
  TOption options[ noption ] = { opevent, ophost, opport };
  TArgument arg( argc, argv, TOptionTable( options, noption ) );

  Tint nevent = 10;
  if ( arg.HasOption( opevent ) ) {
    nevent = arg.GetIntegerParameter( opevent );
  }

  Tstring hostname = "localhost";
  if ( arg.HasOption( ophost ) ) {
    hostname = arg[ ophost ];
  }

  Tint port = 18150;
  if ( arg.HasOption( opport ) ) {
    port = arg.GetIntegerParameter( opport );
  }


  TOutputObjectSocket osocket( hostname, port );
  Tint datasize = 0;
  Tint nevents = 0;

  TBenchmark bench;
  bench.Start();
  for ( Tint i = 0; i < nevent; i ++ ) {
    TDataRecord record;
    record.Test( i );
    osocket << record;
    datasize += record.GetRecordSize();
    nevents ++;
  }
  bench.Stop();
  Tcout << bench << Tendl;

  Tcout << nevents << " events, ";
  Tcout << datasize << Tslash << osocket.GetTotalDataSize();
  Tcout << " byte data has been send to " << hostname << "." << Tendl;

  return 0;
}
