// =====================================================================
//  $Id: St01SignalViewCommand.cc,v 1.4 2003/10/06 16:28:18 goiwai Exp $
//  $Name: CLDAQ-1-12-00 $
//  $Log: St01SignalViewCommand.cc,v $
//  Revision 1.4  2003/10/06 16:28:18  goiwai
//  *** empty log message ***
//
//  Revision 1.3  2003/07/30 16:16:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRunManager.hh"
#include "TEnvironmentVariableTable.hh"
#include "TUserInterface.hh"
#include "TOutputObjectFile.hh"

#include "St01SignalViewCommand.hh"
#include "St01RunAction.hh"

static const Tstring _name = "/local/st01signalview";
static const Tstring _desc = "view histograms, subtracted H.O.C and dark.";

St01SignalViewCommand::St01SignalViewCommand()
  : TCommand( _name, _desc )
{;}

St01SignalViewCommand::~St01SignalViewCommand()
{;}

Tvoid St01SignalViewCommand::Execute( const TstringList& arguments )
{
  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tstring bindir = envtable.GetEnvironmentValue( "ST01_BIN_DIR" );

  TstringList args;
  Tstring comname = bindir + Tslash + "st01signalview";
  Tstring runid = theRunManager -> GetRun().GetStringRunID();
  args.push_back( comname );
  args.push_back( runid );
  args.push_back( "&" );
  

  TUserInterface* ui = theRunManager -> GetUserInterface();
  Tstring com = "/system/shell";
  ui -> ExecuteCommand( com, args );

  return;
}
